/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import org.jetbrains.annotations.NotNull;

class XAddToWatchesAction
extends XDebuggerTreeActionBase {
    XAddToWatchesAction() {
    }

    @Override
    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/actions/XAddToWatchesAction", "isEnabled"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/actions/XAddToWatchesAction", "isEnabled"));
        }
        return super.isEnabled(node, e) && ((XValue)node.getValueContainer()).getEvaluationExpression() != null && XAddToWatchesAction.getWatchesView(e) != null;
    }

    @Override
    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        String expression;
        if (nodeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/intellij/xdebugger/impl/ui/tree/actions/XAddToWatchesAction", "perform"));
        }
        XWatchesView watchesView = XAddToWatchesAction.getWatchesView(e);
        if (watchesView != null && !StringUtil.isEmpty((String)(expression = ((XValue)node.getValueContainer()).getEvaluationExpression()))) {
            watchesView.addWatchExpression(XExpressionImpl.fromText(expression), -1, true);
        }
    }

    private static XWatchesView getWatchesView(@NotNull AnActionEvent e) {
        XDebugSessionTab tab;
        XDebugSession session;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/actions/XAddToWatchesAction", "getWatchesView"));
        }
        XWatchesView view = (XWatchesView)e.getData(XWatchesView.DATA_KEY);
        Project project = e.getProject();
        if (view == null && project != null && (session = XDebuggerManager.getInstance((Project)project).getCurrentSession()) != null && (tab = ((XDebugSessionImpl)session).getSessionTab()) != null) {
            return tab.getWatchesView();
        }
        return view;
    }
}

