/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Convertor;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XDebuggerTreeSpeedSearch
extends TreeSpeedSearch
implements XDebuggerTreeListener {
    public XDebuggerTreeSpeedSearch(XDebuggerTree tree, Convertor<TreePath, String> toStringConvertor) {
        super(tree, toStringConvertor, true);
    }

    @Override
    @Nullable
    protected Object findElement(String s) {
        String string = s.trim();
        XDebuggerTreeNode node = (XDebuggerTreeNode)ObjectUtils.tryCast((Object)((JTree)this.myComponent).getLastSelectedPathComponent(), XDebuggerTreeNode.class);
        if (node == null && (node = (XDebuggerTreeNode)ObjectUtils.tryCast((Object)((JTree)this.myComponent).getModel().getRoot(), XDebuggerTreeNode.class)) == null) {
            return null;
        }
        return this.findPath(string, node, true);
    }

    private Object findPath(String string, XDebuggerTreeNode node, boolean checkChildren) {
        TreePath result;
        TreePath result2;
        int nodeIndex;
        List<? extends TreeNode> parentChildren;
        TreePath path = node.getPath();
        if (this.isMatchingElement(path, string)) {
            return path;
        }
        XDebuggerTreeNode parent = (XDebuggerTreeNode)ObjectUtils.tryCast((Object)node.getParent(), XDebuggerTreeNode.class);
        if (parent != null) {
            parentChildren = parent.getChildren();
            nodeIndex = parentChildren.indexOf(node);
            if (nodeIndex != -1) {
                int i;
                for (i = nodeIndex + 1; i < parentChildren.size(); ++i) {
                    result2 = this.match(parentChildren.get(i), string);
                    if (result2 == null) continue;
                    return result2;
                }
                for (i = nodeIndex - 1; i >= 0; --i) {
                    result2 = this.match(parentChildren.get(i), string);
                    if (result2 == null) continue;
                    return result2;
                }
            }
        } else {
            nodeIndex = -1;
            parentChildren = null;
        }
        if (checkChildren && !node.isLeaf() && (result = this.findInChildren(node, string)) != null) {
            return result;
        }
        if (parent != null) {
            int i;
            for (i = nodeIndex + 1; i < parentChildren.size(); ++i) {
                result2 = this.findInChildren(parentChildren.get(i), string);
                if (result2 == null) continue;
                return result2;
            }
            for (i = nodeIndex - 1; i >= 0; --i) {
                result2 = this.findInChildren(parentChildren.get(i), string);
                if (result2 == null) continue;
                return result2;
            }
            return this.findPath(string, parent, false);
        }
        return null;
    }

    private TreePath findInChildren(TreeNode node, String string) {
        if (node.isLeaf() || !(node instanceof XDebuggerTreeNode)) {
            return null;
        }
        LinkedList<XDebuggerTreeNode> queue = new LinkedList<XDebuggerTreeNode>();
        queue.addLast((XDebuggerTreeNode)node);
        int initialLevel = ((XDebuggerTreeNode)node).getPath().getPathCount();
        while (!queue.isEmpty()) {
            XDebuggerTreeNode p = (XDebuggerTreeNode)queue.removeFirst();
            if (p.getPath().getPathCount() - initialLevel > 3) {
                return null;
            }
            List<? extends TreeNode> children = p.getChildren();
            if (children.isEmpty()) continue;
            for (TreeNode treeNode : children) {
                if (!(treeNode instanceof XDebuggerTreeNode)) continue;
                TreePath result = this.match(treeNode, string);
                if (result != null) {
                    return result;
                }
                if (treeNode.isLeaf()) continue;
                queue.addLast((XDebuggerTreeNode)treeNode);
            }
        }
        return null;
    }

    @Nullable
    private TreePath match(TreeNode node, String string) {
        TreePath path = node instanceof XDebuggerTreeNode ? ((XDebuggerTreeNode)node).getPath() : null;
        return this.isMatchingElement(path, string) ? path : null;
    }

    @Override
    public void nodeLoaded(@NotNull RestorableStateNode node, String name) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch", "nodeLoaded"));
        }
    }

    @Override
    public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<XValueContainerNode<?>> children, boolean last) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch", "childrenLoaded"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch", "childrenLoaded"));
        }
    }
}

