/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.components.ComponentSerializationUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.impl.settings.XDebuggerDataViewSettings;
import com.intellij.xdebugger.impl.settings.XDebuggerGeneralSettings;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="XDebuggerSettings", storages={@Storage(file="$APP_CONFIG$/other.xml")})
public class XDebuggerSettingsManager
extends com.intellij.xdebugger.settings.XDebuggerSettingsManager
implements PersistentStateComponent<SettingsState> {
    @NonNls
    public static final String COMPONENT_NAME = "XDebuggerSettings";
    private Map<String, XDebuggerSettings<?>> mySettingsById;
    private Map<Class<? extends XDebuggerSettings>, XDebuggerSettings<?>> mySettingsByClass;
    private XDebuggerDataViewSettings myDataViewSettings = new XDebuggerDataViewSettings();
    private XDebuggerGeneralSettings myGeneralSettings = new XDebuggerGeneralSettings();

    public static XDebuggerSettingsManager getInstanceImpl() {
        return (XDebuggerSettingsManager)com.intellij.xdebugger.settings.XDebuggerSettingsManager.getInstance();
    }

    public SettingsState getState() {
        SettingsState settingsState = new SettingsState();
        settingsState.setDataViewSettings(this.myDataViewSettings);
        settingsState.setGeneralSettings(this.myGeneralSettings);
        for (XDebuggerSettings<?> settings : this.getSettingsList()) {
            Object subState = settings.getState();
            if (subState == null) continue;
            SpecificSettingsState state2 = new SpecificSettingsState();
            state2.setId(settings.getId());
            state2.setSettingsElement(XmlSerializer.serialize((Object)subState, (SerializationFilter)new SkipDefaultValuesSerializationFilters()));
            settingsState.getSpecificStates().add(state2);
        }
        return settingsState;
    }

    public Collection<XDebuggerSettings<?>> getSettingsList() {
        this.initSettings();
        return Collections.unmodifiableCollection(this.mySettingsById.values());
    }

    @NotNull
    public XDebuggerDataViewSettings getDataViewSettings() {
        XDebuggerDataViewSettings xDebuggerDataViewSettings = this.myDataViewSettings;
        if (xDebuggerDataViewSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/settings/XDebuggerSettingsManager", "getDataViewSettings"));
        }
        return xDebuggerDataViewSettings;
    }

    public XDebuggerGeneralSettings getGeneralSettings() {
        return this.myGeneralSettings;
    }

    public void loadState(SettingsState state2) {
        this.myDataViewSettings = state2.getDataViewSettings();
        this.myGeneralSettings = state2.getGeneralSettings();
        for (SpecificSettingsState settingsState : state2.getSpecificStates()) {
            XDebuggerSettings settings = this.findSettings(settingsState.getId());
            if (settings == null) continue;
            ComponentSerializationUtil.loadComponentState(settings, settingsState.getSettingsElement());
        }
    }

    private XDebuggerSettings findSettings(String id) {
        this.initSettings();
        return this.mySettingsById.get(id);
    }

    private void initSettings() {
        if (this.mySettingsById == null) {
            XDebuggerSettings[] extensions = (XDebuggerSettings[])XDebuggerSettings.EXTENSION_POINT.getExtensions();
            this.mySettingsById = new LinkedHashMap(extensions.length);
            this.mySettingsByClass = new LinkedHashMap(extensions.length);
            for (XDebuggerSettings settings : extensions) {
                this.mySettingsById.put(settings.getId(), settings);
                this.mySettingsByClass.put(settings.getClass(), settings);
            }
        }
    }

    public <T extends XDebuggerSettings<?>> T getSettings(Class<T> aClass) {
        this.initSettings();
        return (T)this.mySettingsByClass.get(aClass);
    }

    @Tag(value="debugger")
    public static class SpecificSettingsState {
        private String myId;
        private Element mySettingsElement;

        @Attribute(value="id")
        public String getId() {
            return this.myId;
        }

        @Tag(value="configuration")
        public Element getSettingsElement() {
            return this.mySettingsElement;
        }

        public void setSettingsElement(Element settingsElement) {
            this.mySettingsElement = settingsElement;
        }

        public void setId(String id) {
            this.myId = id;
        }
    }

    public static class SettingsState {
        private List<SpecificSettingsState> mySpecificStates = new ArrayList<SpecificSettingsState>();
        private XDebuggerDataViewSettings myDataViewSettings = new XDebuggerDataViewSettings();
        private XDebuggerGeneralSettings myGeneralSettings = new XDebuggerGeneralSettings();

        @Tag(value="debuggers")
        @AbstractCollection(surroundWithTag=false)
        public List<SpecificSettingsState> getSpecificStates() {
            return this.mySpecificStates;
        }

        public void setSpecificStates(List<SpecificSettingsState> specificStates) {
            this.mySpecificStates = specificStates;
        }

        @Property(surroundWithTag=false)
        public XDebuggerDataViewSettings getDataViewSettings() {
            return this.myDataViewSettings;
        }

        public void setDataViewSettings(XDebuggerDataViewSettings dataViewSettings) {
            this.myDataViewSettings = dataViewSettings;
        }

        @Property(surroundWithTag=false)
        public XDebuggerGeneralSettings getGeneralSettings() {
            return this.myGeneralSettings;
        }

        public void setGeneralSettings(XDebuggerGeneralSettings generalSettings) {
            this.myGeneralSettings = generalSettings;
        }
    }
}

