/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.NotNullProducer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.evaluate.XValueCompactPresentation;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class XDebuggerEditorLinePainter
extends EditorLinePainter {
    public static final Key<Map<Variable, VariableValue>> CACHE = Key.create((String)"debug.inline.variables.cache");

    @Override
    public Collection<LineExtensionInfo> getLineExtensions(@NotNull Project project, @NotNull VirtualFile file, int lineNumber) {
        Long timestamp;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/XDebuggerEditorLinePainter", "getLineExtensions"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/evaluate/XDebuggerEditorLinePainter", "getLineExtensions"));
        }
        if (!Registry.is((String)"ide.debugger.inline")) {
            return null;
        }
        Map map = (Map)project.getUserData(XVariablesView.DEBUG_VARIABLES);
        Map timestamps = (Map)project.getUserData(XVariablesView.DEBUG_VARIABLES_TIMESTAMPS);
        Document doc = FileDocumentManager.getInstance().getDocument(file);
        if (map == null || timestamps == null || doc == null) {
            return null;
        }
        HashMap<Variable, VariableValue> oldValues = (HashMap<Variable, VariableValue>)project.getUserData(CACHE);
        if (oldValues == null) {
            oldValues = new HashMap<Variable, VariableValue>();
            project.putUserData(CACHE, oldValues);
        }
        if ((timestamp = (Long)timestamps.get(file)) == null || timestamp < doc.getModificationStamp()) {
            return null;
        }
        Set values = (Set)map.get(Pair.create((Object)file, (Object)lineNumber));
        if (values != null && !values.isEmpty()) {
            int bpLine = XDebuggerEditorLinePainter.getCurrentBreakPointLineInFile(values, file);
            ArrayList<VariableText> result = new ArrayList<VariableText>();
            for (XValueNodeImpl value : values) {
                SimpleColoredText simpleColoredText;
                block17: {
                    simpleColoredText = new SimpleColoredText();
                    XValueTextRendererImpl renderer = new XValueTextRendererImpl((ColoredTextContainer)simpleColoredText);
                    XValuePresentation presentation = value.getValuePresentation();
                    if (presentation == null) continue;
                    try {
                        String type;
                        if (presentation instanceof XValueCompactPresentation && !value.getTree().isUnderRemoteDebug()) {
                            ((XValueCompactPresentation)presentation).renderValue(renderer, value);
                        } else {
                            presentation.renderValue((XValuePresentation.XValueTextRenderer)renderer);
                        }
                        if (!StringUtil.isEmpty((String)simpleColoredText.toString()) || StringUtil.isEmpty((String)(type = value.getValuePresentation().getType()))) break block17;
                        simpleColoredText.append(type, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                JBColor color = bpLine == lineNumber ? new JBColor(new Color(0, 255, 86), new Color(255, 235, 9)) : XDebuggerEditorLinePainter.getForeground();
                String name = value.getName();
                if (StringUtil.isEmpty((String)simpleColoredText.toString())) continue;
                VariableText res = new VariableText();
                result.add(res);
                res.add(new LineExtensionInfo("  " + name + ": ", (Color)color, null, null, 2));
                Variable var = new Variable(name, lineNumber);
                VariableValue variableValue = (VariableValue)oldValues.get(var);
                if (variableValue == null) {
                    variableValue = new VariableValue(simpleColoredText.toString(), null, value.hashCode());
                    oldValues.put(var, variableValue);
                }
                if (variableValue.valueNodeHashCode != value.hashCode()) {
                    variableValue.old = variableValue.actual;
                    variableValue.actual = simpleColoredText.toString();
                    variableValue.valueNodeHashCode = value.hashCode();
                }
                if (!variableValue.isChanged()) {
                    for (String s : simpleColoredText.getTexts()) {
                        res.add(new LineExtensionInfo(s, (Color)color, null, null, 2));
                    }
                    continue;
                }
                variableValue.produceChangedParts(res.infos);
            }
            Collections.sort(result, new Comparator<VariableText>(){

                @Override
                public int compare(VariableText o1, VariableText o2) {
                    return o1.length - o2.length;
                }
            });
            ArrayList<LineExtensionInfo> infos = new ArrayList<LineExtensionInfo>();
            for (VariableText variableText : result) {
                infos.addAll(variableText.infos);
            }
            return infos;
        }
        return null;
    }

    private static int getCurrentBreakPointLineInFile(Set<XValueNodeImpl> values, VirtualFile file) {
        try {
            XSourcePosition position;
            XValueNodeImpl node = values.iterator().next();
            XDebugSession session = XDebugView.getSession((Component)((Object)node.getTree()));
            if (session != null && (position = session.getCurrentPosition()) != null && position.getFile().equals(file)) {
                return position.getLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private static boolean isDarkEditor() {
        Color bg = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
        return ColorUtil.isDark((Color)bg);
    }

    public static JBColor getForeground() {
        return new JBColor((NotNullProducer)new NotNullProducer<Color>(){

            @NotNull
            public Color produce() {
                Color color = XDebuggerEditorLinePainter.isDarkEditor() ? Registry.getColor((String)"ide.debugger.inline.dark.fg.color", (Color)new Color(4030565)) : Registry.getColor((String)"ide.debugger.inline.fg.color", (Color)new Color(4030565));
                if (color == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/XDebuggerEditorLinePainter$2", "produce"));
                }
                return color;
            }
        });
    }

    public static JBColor getChangedForeground() {
        return new JBColor((NotNullProducer)new NotNullProducer<Color>(){

            @NotNull
            public Color produce() {
                Color color = XDebuggerEditorLinePainter.isDarkEditor() ? Registry.getColor((String)"ide.debugger.inline.dark.fg.modified.color", (Color)new Color(10584842)) : Registry.getColor((String)"ide.debugger.inline.fg.modified.color", (Color)new Color(13271073));
                if (color == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/XDebuggerEditorLinePainter$3", "produce"));
                }
                return color;
            }
        });
    }

    private static class VariableText {
        List<LineExtensionInfo> infos = new ArrayList<LineExtensionInfo>();
        int length = 0;

        private VariableText() {
        }

        void add(LineExtensionInfo info) {
            this.infos.add(info);
            this.length += info.getText().length();
        }
    }

    static class VariableValue {
        private String actual;
        private String old;
        private int valueNodeHashCode;

        public VariableValue(String actual, String old, int valueNodeHashCode) {
            this.actual = actual;
            this.old = old;
            this.valueNodeHashCode = valueNodeHashCode;
        }

        public boolean isChanged() {
            return this.old != null && !StringUtil.equals((CharSequence)this.actual, (CharSequence)this.old);
        }

        public void produceChangedParts(List<LineExtensionInfo> result) {
            if (VariableValue.isArray(this.actual) && VariableValue.isArray(this.old)) {
                List<String> actualParts = VariableValue.getArrayParts(this.actual);
                List<String> oldParts = VariableValue.getArrayParts(this.old);
                result.add(new LineExtensionInfo("{", (Color)XDebuggerEditorLinePainter.getForeground(), null, null, 2));
                for (int i = 0; i < actualParts.size(); ++i) {
                    if (i < oldParts.size() && StringUtil.equals((CharSequence)actualParts.get(i), (CharSequence)oldParts.get(i))) {
                        result.add(new LineExtensionInfo(actualParts.get(i), (Color)XDebuggerEditorLinePainter.getForeground(), null, null, 2));
                    } else {
                        result.add(new LineExtensionInfo(actualParts.get(i), (Color)XDebuggerEditorLinePainter.getChangedForeground(), null, null, 2));
                    }
                    if (i == actualParts.size() - 1) continue;
                    result.add(new LineExtensionInfo(", ", (Color)XDebuggerEditorLinePainter.getForeground(), null, null, 2));
                }
                result.add(new LineExtensionInfo("}", (Color)XDebuggerEditorLinePainter.getForeground(), null, null, 2));
                return;
            }
            result.add(new LineExtensionInfo(this.actual, (Color)XDebuggerEditorLinePainter.getChangedForeground(), null, null, 2));
        }

        private static boolean isArray(String s) {
            return s != null && s.startsWith("{") && s.endsWith("}");
        }

        private static List<String> getArrayParts(String array) {
            return StringUtil.split((String)array.substring(1, array.length() - 1), (String)", ");
        }
    }

    static class Variable {
        private int lineNumber;
        private String name;

        public Variable(String name, int lineNumber) {
            this.lineNumber = lineNumber;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            if (this.lineNumber != variable.lineNumber) {
                return false;
            }
            return this.name.equals(variable.name);
        }

        public int hashCode() {
            int result = this.lineNumber;
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

