/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.LineBreakpointState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Cursor;
import java.awt.dnd.DragSource;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XLineBreakpointImpl<P extends XBreakpointProperties>
extends XBreakpointBase<XLineBreakpoint<P>, P, LineBreakpointState<P>>
implements XLineBreakpoint<P> {
    @Nullable
    private RangeHighlighterEx myHighlighter;
    private final XLineBreakpointType<P> myType;
    private XSourcePosition mySourcePosition;
    private boolean myDisposed;

    public XLineBreakpointImpl(XLineBreakpointType<P> type, XBreakpointManagerImpl breakpointManager, @Nullable P properties, LineBreakpointState<P> state2) {
        super(type, breakpointManager, properties, state2);
        this.myType = type;
    }

    XLineBreakpointImpl(XLineBreakpointType<P> type, XBreakpointManagerImpl breakpointManager, LineBreakpointState<P> breakpointState) {
        super(type, breakpointManager, breakpointState);
        this.myType = type;
    }

    public void updateUI() {
        MarkupModelEx markupModel;
        if (this.myDisposed || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = scheme.getAttributes(DebuggerColors.BREAKPOINT_ATTRIBUTES);
        RangeHighlighterEx highlighter = this.myHighlighter;
        if (!(highlighter == null || highlighter.isValid() && DocumentUtil.isValidOffset(highlighter.getStartOffset(), document) && Comparing.equal((Object)highlighter.getTextAttributes(), (Object)attributes))) {
            this.removeHighlighter();
            highlighter = null;
        }
        if (highlighter == null) {
            markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.getProject(), true);
            highlighter = markupModel.addPersistentLineHighlighter(this.getLine(), 2001, attributes);
            if (highlighter == null) {
                return;
            }
            highlighter.setGutterIconRenderer(this.createGutterIconRenderer());
            highlighter.putUserData(DebuggerColors.BREAKPOINT_HIGHLIGHTER_KEY, Boolean.TRUE);
            highlighter.setEditorFilter(MarkupEditorFilterFactory.createIsNotDiffFilter());
            this.myHighlighter = highlighter;
        } else {
            markupModel = null;
        }
        this.updateIcon();
        if (markupModel == null && (markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.getProject(), false)) != null) {
            markupModel.fireAttributesChanged(highlighter, false);
        }
    }

    @Nullable
    public Document getDocument() {
        VirtualFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(file);
    }

    @Nullable
    private VirtualFile getFile() {
        return VirtualFileManager.getInstance().findFileByUrl(this.getFileUrl());
    }

    @NotNull
    public XLineBreakpointType<P> getType() {
        XLineBreakpointType<P> xLineBreakpointType = this.myType;
        if (xLineBreakpointType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl", "getType"));
        }
        return xLineBreakpointType;
    }

    public int getLine() {
        return ((LineBreakpointState)this.myState).getLine();
    }

    public String getFileUrl() {
        return ((LineBreakpointState)this.myState).getFileUrl();
    }

    public String getPresentableFilePath() {
        String url = this.getFileUrl();
        if (url != null && "file".equals(VirtualFileManager.extractProtocol((String)url))) {
            return FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url));
        }
        return url != null ? url : "";
    }

    public String getShortFilePath() {
        String path = this.getPresentableFilePath();
        if (path.isEmpty()) {
            return "";
        }
        return new File(path).getName();
    }

    @Nullable
    public RangeHighlighter getHighlighter() {
        return this.myHighlighter;
    }

    @Override
    public XSourcePosition getSourcePosition() {
        if (this.mySourcePosition == null) {
            new ReadAction(){

                protected void run(@NotNull Result result) {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl$1", "run"));
                    }
                    XLineBreakpointImpl.this.mySourcePosition = XDebuggerUtil.getInstance().createPosition(XLineBreakpointImpl.this.getFile(), XLineBreakpointImpl.this.getLine());
                }
            }.execute();
        }
        return this.mySourcePosition;
    }

    @Override
    public boolean isValid() {
        return this.myHighlighter != null && this.myHighlighter.isValid();
    }

    @Override
    public void dispose() {
        this.removeHighlighter();
        this.myDisposed = true;
    }

    private void removeHighlighter() {
        if (this.myHighlighter != null) {
            this.myHighlighter.dispose();
            this.myHighlighter = null;
        }
    }

    @Override
    protected GutterDraggableObject createBreakpointDraggableObject() {
        return new GutterDraggableObject(){

            public boolean copy(int line, VirtualFile file) {
                if (XLineBreakpointImpl.this.canMoveTo(line, file)) {
                    XLineBreakpointImpl.this.setFileUrl(file.getUrl());
                    XLineBreakpointImpl.this.setLine(line, true);
                    return true;
                }
                return false;
            }

            public Cursor getCursor(int line) {
                return XLineBreakpointImpl.this.canMoveTo(line, XLineBreakpointImpl.this.getFile()) ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop;
            }
        };
    }

    private boolean canMoveTo(int line, VirtualFile file) {
        return file != null && this.myType.canPutAt(file, line, this.getProject()) && this.getBreakpointManager().findBreakpointAtLine(this.myType, file, line) == null;
    }

    public void updatePosition() {
        if (this.myHighlighter != null && this.myHighlighter.isValid()) {
            this.setLine(this.myHighlighter.getDocument().getLineNumber(this.myHighlighter.getStartOffset()), false);
        }
    }

    public void setFileUrl(String newUrl) {
        if (!Comparing.equal((String)this.getFileUrl(), (String)newUrl)) {
            ((LineBreakpointState)this.myState).setFileUrl(newUrl);
            this.mySourcePosition = null;
            this.removeHighlighter();
            this.fireBreakpointChanged();
        }
    }

    private void setLine(int line, boolean removeHighlighter) {
        if (this.getLine() != line) {
            ((LineBreakpointState)this.myState).setLine(line);
            this.mySourcePosition = null;
            if (removeHighlighter) {
                this.removeHighlighter();
            }
            this.fireBreakpointChanged();
        }
    }

    public boolean isTemporary() {
        return ((LineBreakpointState)this.myState).isTemporary();
    }

    public void setTemporary(boolean temporary) {
        if (this.isTemporary() != temporary) {
            ((LineBreakpointState)this.myState).setTemporary(temporary);
            this.fireBreakpointChanged();
        }
    }

    @Override
    protected List<? extends AnAction> getAdditionalPopupMenuActions(XDebugSession session) {
        return this.getType().getAdditionalPopupMenuActions((XLineBreakpoint)this, session);
    }

    @Override
    protected void updateIcon() {
        Icon icon = this.calculateSpecialIcon();
        if (icon != null) {
            this.setIcon(icon);
            return;
        }
        this.setIcon(this.isTemporary() ? this.myType.getTemporaryIcon() : this.myType.getEnabledIcon());
    }

    @Override
    public String toString() {
        return "XLineBreakpointImpl(" + this.myType.getId() + " at " + this.getShortFilePath() + ":" + this.getLine() + ")";
    }
}

