/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointAdapter;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointDependencyState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointListener;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDependentBreakpointManager {
    private final Map<XBreakpoint<?>, XDependentBreakpointInfo> mySlave2Info = new HashMap();
    private final MultiValuesMap<XBreakpointBase, XDependentBreakpointInfo> myMaster2Info = new MultiValuesMap();
    private final XBreakpointManagerImpl myBreakpointManager;
    private final EventDispatcher<XDependentBreakpointListener> myDispatcher;

    public XDependentBreakpointManager(XBreakpointManagerImpl breakpointManager) {
        this.myBreakpointManager = breakpointManager;
        this.myDispatcher = EventDispatcher.create(XDependentBreakpointListener.class);
        this.myBreakpointManager.addBreakpointListener((XBreakpointListener<XBreakpoint<?>>)new XBreakpointAdapter<XBreakpoint<?>>(){

            public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
                Collection infos;
                if (breakpoint == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManager$1", "breakpointRemoved"));
                }
                XDependentBreakpointInfo info = (XDependentBreakpointInfo)XDependentBreakpointManager.this.mySlave2Info.remove(breakpoint);
                if (info != null) {
                    XDependentBreakpointManager.this.myMaster2Info.remove((Object)info.myMasterBreakpoint, (Object)info);
                }
                if ((infos = XDependentBreakpointManager.this.myMaster2Info.removeAll((Object)((XBreakpointBase)breakpoint))) != null) {
                    for (XDependentBreakpointInfo breakpointInfo : infos) {
                        XDependentBreakpointInfo removed = (XDependentBreakpointInfo)XDependentBreakpointManager.this.mySlave2Info.remove(breakpointInfo.mySlaveBreakpoint);
                        if (removed == null) continue;
                        ((XDependentBreakpointListener)XDependentBreakpointManager.this.myDispatcher.getMulticaster()).dependencyCleared(breakpointInfo.mySlaveBreakpoint);
                    }
                }
            }
        });
    }

    public void addListener(XDependentBreakpointListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(XDependentBreakpointListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void loadState() {
        XBreakpointDependencyState state2;
        this.mySlave2Info.clear();
        this.myMaster2Info.clear();
        HashMap id2Breakpoint = new HashMap();
        for (XBreakpointBase<?, ?, ?> breakpoint : this.myBreakpointManager.getAllBreakpoints()) {
            String id;
            state2 = breakpoint.getDependencyState();
            if (state2 == null || (id = state2.getId()) == null) continue;
            id2Breakpoint.put(id, breakpoint);
        }
        for (XBreakpointBase<?, ?, ?> breakpoint : this.myBreakpointManager.getAllBreakpoints()) {
            XBreakpointBase master;
            String masterId;
            state2 = breakpoint.getDependencyState();
            if (state2 == null || (masterId = state2.getMasterBreakpointId()) == null || (master = (XBreakpointBase)id2Breakpoint.get(masterId)) == null) continue;
            this.addDependency(master, breakpoint, state2.isLeaveEnabled());
        }
    }

    public void saveState() {
        HashMap<XBreakpointBase, String> breakpoint2Id = new HashMap<XBreakpointBase, String>();
        int id = 0;
        for (XBreakpointBase xBreakpointBase : this.myMaster2Info.keySet()) {
            breakpoint2Id.put(xBreakpointBase, String.valueOf(id++));
        }
        for (XDependentBreakpointInfo xDependentBreakpointInfo : this.mySlave2Info.values()) {
            XBreakpointDependencyState state2 = new XBreakpointDependencyState((String)breakpoint2Id.get(xDependentBreakpointInfo.mySlaveBreakpoint), (String)breakpoint2Id.get(xDependentBreakpointInfo.myMasterBreakpoint), xDependentBreakpointInfo.myLeaveEnabled);
            xDependentBreakpointInfo.mySlaveBreakpoint.setDependencyState(state2);
        }
        for (Map.Entry entry : breakpoint2Id.entrySet()) {
            if (this.mySlave2Info.containsKey(entry.getKey())) continue;
            ((XBreakpointBase)entry.getKey()).setDependencyState(new XBreakpointDependencyState((String)entry.getValue()));
        }
    }

    public void setMasterBreakpoint(@NotNull XBreakpoint<?> slave, @NotNull XBreakpoint<?> master, boolean leaveEnabled) {
        if (slave == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slave", "com/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManager", "setMasterBreakpoint"));
        }
        if (master == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "master", "com/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManager", "setMasterBreakpoint"));
        }
        XDependentBreakpointInfo info = this.mySlave2Info.get(slave);
        if (info == null) {
            this.addDependency((XBreakpointBase)master, (XBreakpointBase)slave, leaveEnabled);
        } else if (info.myMasterBreakpoint == master) {
            info.myLeaveEnabled = leaveEnabled;
        } else {
            this.myMaster2Info.remove((Object)info.myMasterBreakpoint, (Object)info);
            info.myMasterBreakpoint = (XBreakpointBase)master;
            info.myLeaveEnabled = leaveEnabled;
            this.myMaster2Info.put((Object)((XBreakpointBase)master), (Object)info);
        }
        ((XDependentBreakpointListener)this.myDispatcher.getMulticaster()).dependencySet(slave, master);
    }

    public void clearMasterBreakpoint(@NotNull XBreakpoint<?> slave) {
        if (slave == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slave", "com/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManager", "clearMasterBreakpoint"));
        }
        XDependentBreakpointInfo info = this.mySlave2Info.remove(slave);
        if (info != null) {
            this.myMaster2Info.remove((Object)info.myMasterBreakpoint, (Object)info);
            ((XDependentBreakpointListener)this.myDispatcher.getMulticaster()).dependencyCleared(slave);
        }
    }

    private void addDependency(XBreakpointBase<?, ?, ?> master, XBreakpointBase<?, ?, ?> slave, boolean leaveEnabled) {
        XDependentBreakpointInfo info = new XDependentBreakpointInfo(master, slave, leaveEnabled);
        this.mySlave2Info.put(slave, info);
        this.myMaster2Info.put(master, (Object)info);
    }

    @Nullable
    public XBreakpoint<?> getMasterBreakpoint(@NotNull XBreakpoint<?> slave) {
        if (slave == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slave", "com/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManager", "getMasterBreakpoint"));
        }
        XDependentBreakpointInfo info = this.mySlave2Info.get(slave);
        return info != null ? info.myMasterBreakpoint : null;
    }

    public boolean isLeaveEnabled(@NotNull XBreakpoint<?> slave) {
        if (slave == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slave", "com/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManager", "isLeaveEnabled"));
        }
        XDependentBreakpointInfo info = this.mySlave2Info.get(slave);
        return info != null && info.myLeaveEnabled;
    }

    public List<XBreakpoint<?>> getSlaveBreakpoints(XBreakpoint<?> breakpoint) {
        Collection slaveInfos = this.myMaster2Info.get((Object)((XBreakpointBase)breakpoint));
        if (slaveInfos == null) {
            return Collections.emptyList();
        }
        SmartList breakpoints = new SmartList();
        for (XDependentBreakpointInfo slaveInfo : slaveInfos) {
            breakpoints.add(slaveInfo.mySlaveBreakpoint);
        }
        return breakpoints;
    }

    public boolean isMasterOrSlave(XBreakpoint<?> breakpoint) {
        return this.myMaster2Info.containsKey((Object)((XBreakpointBase)breakpoint)) || this.mySlave2Info.containsKey(breakpoint);
    }

    public Set<XBreakpoint<?>> getAllSlaveBreakpoints() {
        return this.mySlave2Info.keySet();
    }

    private static class XDependentBreakpointInfo {
        private XBreakpointBase myMasterBreakpoint;
        private final XBreakpointBase mySlaveBreakpoint;
        private boolean myLeaveEnabled;

        private XDependentBreakpointInfo(@NotNull XBreakpointBase masterBreakpoint, XBreakpointBase slaveBreakpoint, boolean leaveEnabled) {
            if (masterBreakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "masterBreakpoint", "com/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManager$XDependentBreakpointInfo", "<init>"));
            }
            this.myMasterBreakpoint = masterBreakpoint;
            this.myLeaveEnabled = leaveEnabled;
            this.mySlaveBreakpoint = slaveBreakpoint;
        }
    }
}

