/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.MarkObjectActionHandler;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkerPresentationDialog;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XMarkObjectActionHandler
extends MarkObjectActionHandler {
    @Override
    public void perform(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/handlers/XMarkObjectActionHandler", "perform"));
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (session == null) {
            return;
        }
        XValueMarkers<?, ?> markers = ((XDebugSessionImpl)session).getValueMarkers();
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(event.getDataContext());
        if (markers == null || node == null) {
            return;
        }
        XValue value = (XValue)node.getValueContainer();
        ValueMarkup existing = markers.getMarkup(value);
        if (existing != null) {
            markers.unmarkValue(value);
        } else {
            ValueMarkerPresentationDialog dialog = new ValueMarkerPresentationDialog((Component)event.getData(PlatformDataKeys.CONTEXT_COMPONENT), node.getName());
            dialog.show();
            ValueMarkup markup = dialog.getConfiguredMarkup();
            if (dialog.isOK() && markup != null) {
                markers.markValue(value, markup);
            }
        }
        session.rebuildViews();
    }

    @Override
    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/handlers/XMarkObjectActionHandler", "isEnabled"));
        }
        XValueMarkers<?, ?> markers = XMarkObjectActionHandler.getValueMarkers(project);
        if (markers == null) {
            return false;
        }
        XValue value = XDebuggerTreeActionBase.getSelectedValue(event.getDataContext());
        return value != null && markers.canMarkValue(value);
    }

    @Override
    public boolean isMarked(@NotNull Project project, @NotNull AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/handlers/XMarkObjectActionHandler", "isMarked"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/actions/handlers/XMarkObjectActionHandler", "isMarked"));
        }
        XValueMarkers<?, ?> markers = XMarkObjectActionHandler.getValueMarkers(project);
        if (markers == null) {
            return false;
        }
        XValue value = XDebuggerTreeActionBase.getSelectedValue(event.getDataContext());
        return value != null && markers.getMarkup(value) != null;
    }

    @Override
    public boolean isHidden(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/handlers/XMarkObjectActionHandler", "isHidden"));
        }
        return XMarkObjectActionHandler.getValueMarkers(project) == null;
    }

    @Nullable
    private static XValueMarkers<?, ?> getValueMarkers(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/handlers/XMarkObjectActionHandler", "getValueMarkers"));
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        return session != null ? ((XDebugSessionImpl)session).getValueMarkers() : null;
    }
}

