/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.VirtualFileListCellRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PlusMinus;
import com.intellij.util.TreeNodeState;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.treeWithCheckedNodes.SelectionManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsStructureChooser
extends DialogWrapper {
    private static final int MAX_FOLDERS = 100;
    public static final Border BORDER = IdeBorderFactory.createBorder((int)3);
    public static final String DEFAULT_TEXT = "<html>Selected:</html>";
    public static final String CAN_NOT_ADD_TEXT = "<html>Selected: <font color=red>(You have added 100 elements. No more is allowed.)</font></html>";
    @NotNull
    private final Project myProject;
    private Set<VirtualFile> myRoots;
    private Map<VirtualFile, String> myModulesSet;
    private SelectionManager mySelectionManager;
    private DefaultMutableTreeNode myRoot;
    private JBList mySelectedList;
    private JLabel mySelectedLabel;
    private Tree myTree;
    private final List<VirtualFile> myInitialRoots;

    public VcsStructureChooser(@NotNull Project project, String title, Collection<VirtualFile> initialSelection, List<VirtualFile> initialRoots) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/VcsStructureChooser", "<init>"));
        }
        super(project, true);
        this.myInitialRoots = initialRoots;
        this.setTitle(title);
        this.myProject = project;
        this.mySelectionManager = new SelectionManager(100, 500, MyNodeConvertor.getInstance());
        this.init();
        this.mySelectionManager.setSelection(initialSelection);
        this.checkEmptyness();
    }

    private void calculateRoots() {
        final ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Module[] modules = (Module[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module[]>(){

            public Module[] compute() {
                return moduleManager.getModules();
            }
        });
        TreeSet<VirtualFile> checkSet = new TreeSet<VirtualFile>((Comparator<VirtualFile>)FilePathComparator.getInstance());
        this.myRoots = new HashSet();
        this.myRoots.addAll(this.myInitialRoots);
        checkSet.addAll(this.myInitialRoots);
        this.myModulesSet = new HashMap<VirtualFile, String>();
        for (Module module : modules) {
            VirtualFile[] files;
            for (VirtualFile file : files = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                VirtualFile floor = checkSet.floor(file);
                if (floor == null) continue;
                this.myModulesSet.put(file, module.getName());
                this.myRoots.add(file);
            }
        }
    }

    public Map<VirtualFile, String> getModulesSet() {
        return this.myModulesSet;
    }

    @NotNull
    public Collection<VirtualFile> getSelectedFiles() {
        List list = ((CollectionListModel)this.mySelectedList.getModel()).getItems();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsStructureChooser", "getSelectedFiles"));
        }
        return list;
    }

    private void checkEmptyness() {
        this.setOKActionEnabled(this.mySelectedList.getModel().getSize() > 0);
    }

    protected String getDimensionServiceKey() {
        return "git4idea.history.wholeTree.VcsStructureChooser";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    protected JComponent createCenterPanel() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createAllButJarContentsDescriptor();
        this.calculateRoots();
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>(this.myRoots);
        final Comparator<VirtualFile> comparator = new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile o1, VirtualFile o2) {
                boolean isDir2;
                boolean isDir1 = o1.isDirectory();
                if (isDir1 != (isDir2 = o2.isDirectory())) {
                    return isDir1 ? -1 : 1;
                }
                String module1 = (String)VcsStructureChooser.this.myModulesSet.get(o1);
                String path1 = module1 != null ? module1 : o1.getPath();
                String module2 = (String)VcsStructureChooser.this.myModulesSet.get(o2);
                String path2 = module2 != null ? module2 : o2.getPath();
                return path1.compareToIgnoreCase(path2);
            }
        };
        descriptor.setRoots(list);
        this.myTree = new Tree();
        this.myTree.setMinimumSize(new Dimension(200, 200));
        this.myTree.setBorder(BORDER);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(true);
        this.myTree.getExpandableItemsHandler().setEnabled(false);
        final MyCheckboxTreeCellRenderer cellRenderer = new MyCheckboxTreeCellRenderer(this.mySelectionManager, this.myModulesSet, this.myProject, (JTree)this.myTree, this.myRoots);
        FileSystemTreeImpl fileSystemTree = new FileSystemTreeImpl(this.myProject, descriptor, this.myTree, cellRenderer, null, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)o.getLastPathComponent();
                Object uo = lastPathComponent.getUserObject();
                if (uo instanceof FileNodeDescriptor) {
                    VirtualFile file = ((FileNodeDescriptor)((Object)uo)).getElement().getFile();
                    String module = (String)VcsStructureChooser.this.myModulesSet.get(file);
                    if (module != null) {
                        return module;
                    }
                    return file == null ? "" : file.getName();
                }
                return o.toString();
            }
        });
        AbstractTreeUi ui = fileSystemTree.getTreeBuilder().getUi();
        ui.setNodeDescriptorComparator((Comparator)new Comparator<NodeDescriptor>(){

            @Override
            public int compare(NodeDescriptor o1, NodeDescriptor o2) {
                if (o1 instanceof FileNodeDescriptor && o2 instanceof FileNodeDescriptor) {
                    VirtualFile f1 = ((FileNodeDescriptor)o1).getElement().getFile();
                    VirtualFile f2 = ((FileNodeDescriptor)o2).getElement().getFile();
                    return comparator.compare(f1, f2);
                }
                return o1.getIndex() - o2.getIndex();
            }
        });
        this.myRoot = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/VcsStructureChooser$5", "onClick"));
                }
                int row = VcsStructureChooser.this.myTree.getRowForLocation(e.getX(), e.getY());
                if (row < 0) {
                    return false;
                }
                Object o = VcsStructureChooser.this.myTree.getPathForRow(row).getLastPathComponent();
                if (VcsStructureChooser.this.myRoot == o || VcsStructureChooser.getFile(o) == null) {
                    return false;
                }
                Rectangle rowBounds = VcsStructureChooser.this.myTree.getRowBounds(row);
                cellRenderer.setBounds(rowBounds);
                Rectangle checkBounds = cellRenderer.myCheckbox.getBounds();
                checkBounds.setLocation(rowBounds.getLocation());
                if (checkBounds.height == 0) {
                    checkBounds.height = rowBounds.height;
                }
                if (checkBounds.contains(e.getPoint())) {
                    VcsStructureChooser.this.mySelectionManager.toggleSelection((DefaultMutableTreeNode)o);
                    VcsStructureChooser.this.myTree.revalidate();
                    VcsStructureChooser.this.myTree.repaint();
                }
                return true;
            }
        }.installOn((Component)this.myTree);
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    TreePath treePath = VcsStructureChooser.this.myTree.getLeadSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    Object o = treePath.getLastPathComponent();
                    if (VcsStructureChooser.this.myRoot == o || VcsStructureChooser.getFile(o) == null) {
                        return;
                    }
                    VcsStructureChooser.this.mySelectionManager.toggleSelection((DefaultMutableTreeNode)o);
                    VcsStructureChooser.this.myTree.revalidate();
                    VcsStructureChooser.this.myTree.repaint();
                    e.consume();
                }
            }
        });
        final Splitter splitter = new Splitter(true, 0.7f);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)new Disposable(){

            public void dispose() {
                splitter.dispose();
            }
        });
        splitter.setFirstComponent((JComponent)new JBScrollPane((Component)fileSystemTree.getTree()));
        JPanel wrapper = new JPanel(new BorderLayout());
        this.mySelectedLabel = new JLabel(DEFAULT_TEXT);
        this.mySelectedLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        wrapper.add((Component)this.mySelectedLabel, "North");
        this.mySelectedList = new JBList((ListModel)new CollectionListModel(new ArrayList()));
        this.mySelectedList.setCellRenderer((ListCellRenderer)((Object)new WithModulesListCellRenderer(this.myProject, this.myModulesSet)));
        wrapper.add((Component)ScrollPaneFactory.createScrollPane((Component)this.mySelectedList), "Center");
        splitter.setSecondComponent((JComponent)wrapper);
        this.mySelectionManager.setSelectionChangeListener(new PlusMinus<VirtualFile>(){

            public void plus(VirtualFile virtualFile) {
                CollectionListModel model = (CollectionListModel)VcsStructureChooser.this.mySelectedList.getModel();
                model.add((Object)virtualFile);
                model.sort((Comparator)FilePathComparator.getInstance());
                this.recalculateErrorText();
                VcsStructureChooser.this.mySelectedList.revalidate();
                VcsStructureChooser.this.mySelectedList.repaint();
            }

            private void recalculateErrorText() {
                VcsStructureChooser.this.checkEmptyness();
                if (VcsStructureChooser.this.mySelectionManager.canAddSelection()) {
                    VcsStructureChooser.this.mySelectedLabel.setText(VcsStructureChooser.DEFAULT_TEXT);
                } else {
                    VcsStructureChooser.this.mySelectedLabel.setText(VcsStructureChooser.CAN_NOT_ADD_TEXT);
                }
                VcsStructureChooser.this.mySelectedLabel.revalidate();
            }

            public void minus(VirtualFile virtualFile) {
                CollectionListModel defaultListModel = (CollectionListModel)VcsStructureChooser.this.mySelectedList.getModel();
                for (int i = 0; i < defaultListModel.getSize(); ++i) {
                    VirtualFile elementAt = (VirtualFile)defaultListModel.getElementAt(i);
                    if (!virtualFile.equals(elementAt)) continue;
                    defaultListModel.remove(i);
                    break;
                }
                defaultListModel.sort((Comparator)FilePathComparator.getInstance());
                this.recalculateErrorText();
                VcsStructureChooser.this.mySelectedList.revalidate();
                VcsStructureChooser.this.mySelectedList.repaint();
            }
        });
        this.mySelectedList.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int answer;
                int[] idx;
                if (e.getModifiers() == 0 && e.getKeyCode() == 127 && (idx = VcsStructureChooser.this.mySelectedList.getSelectedIndices()) != null && idx.length > 0 && 0 == (answer = Messages.showYesNoDialog((Project)VcsStructureChooser.this.myProject, (String)"Remove selected paths from filter?", (String)"Remove from filter", (Icon)Messages.getQuestionIcon()))) {
                    Arrays.sort(idx);
                    for (int i = idx.length - 1; i >= 0; --i) {
                        int i1 = idx[i];
                        VcsStructureChooser.this.mySelectionManager.removeSelection((VirtualFile)((CollectionListModel)VcsStructureChooser.this.mySelectedList.getModel()).getElementAt(i1));
                        VcsStructureChooser.this.myTree.revalidate();
                        VcsStructureChooser.this.myTree.repaint();
                    }
                }
            }
        });
        return splitter;
    }

    @Nullable
    private static VirtualFile getFile(Object node) {
        if (!(((DefaultMutableTreeNode)node).getUserObject() instanceof FileNodeDescriptor)) {
            return null;
        }
        FileNodeDescriptor descriptor = (FileNodeDescriptor)((Object)((DefaultMutableTreeNode)node).getUserObject());
        if (descriptor.getElement().getFile() == null) {
            return null;
        }
        return descriptor.getElement().getFile();
    }

    private static class WithModulesListCellRenderer
    extends VirtualFileListCellRenderer {
        private final Map<VirtualFile, String> myModules;

        private WithModulesListCellRenderer(Project project, Map<VirtualFile, String> modules) {
            super(project, true);
            this.myModules = modules;
        }

        @Override
        protected String getName(FilePath path) {
            String module = this.myModules.get(path.getVirtualFile());
            if (module != null) {
                return module;
            }
            return super.getName(path);
        }

        @Override
        protected void renderIcon(FilePath path) {
            String module = this.myModules.get(path.getVirtualFile());
            if (module != null) {
                this.setIcon(PlatformIcons.CONTENT_ROOT_ICON_CLOSED);
            } else if (path.isDirectory()) {
                this.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
            } else {
                this.setIcon(path.getFileType().getIcon());
            }
        }

        @Override
        protected void putParentPathImpl(Object value, String parentPath, FilePath self) {
            this.append(self.getPath(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    private static class MyNodeConvertor
    implements Convertor<DefaultMutableTreeNode, VirtualFile> {
        private static final MyNodeConvertor ourInstance = new MyNodeConvertor();

        private MyNodeConvertor() {
        }

        public static MyNodeConvertor getInstance() {
            return ourInstance;
        }

        public VirtualFile convert(DefaultMutableTreeNode o) {
            return ((FileNodeDescriptor)((Object)o.getUserObject())).getElement().getFile();
        }
    }

    private static class MyCheckboxTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final WithModulesListCellRenderer myTextRenderer;
        public final JCheckBox myCheckbox;
        private final SelectionManager mySelectionManager;
        private final Map<VirtualFile, String> myModulesSet;
        private final Collection<VirtualFile> myRoots;
        private final ColoredTreeCellRenderer myColoredRenderer;
        private final JLabel myEmpty;
        private final JList myFictive;

        private MyCheckboxTreeCellRenderer(SelectionManager selectionManager, Map<VirtualFile, String> modulesSet, Project project, JTree tree, Collection<VirtualFile> roots) {
            super(new BorderLayout());
            this.mySelectionManager = selectionManager;
            this.myModulesSet = modulesSet;
            this.myRoots = roots;
            this.setBackground(tree.getBackground());
            this.myColoredRenderer = new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    this.append(value.toString());
                }
            };
            this.myFictive = new JBList();
            this.myFictive.setBackground(tree.getBackground());
            this.myFictive.setSelectionBackground(UIUtil.getListSelectionBackground());
            this.myFictive.setSelectionForeground(UIUtil.getListSelectionForeground());
            this.myTextRenderer = new WithModulesListCellRenderer(project, this.myModulesSet){

                @Override
                protected void putParentPath(Object value, FilePath path, FilePath self) {
                    if (MyCheckboxTreeCellRenderer.this.myRoots.contains(self.getVirtualFile())) {
                        super.putParentPath(value, path, self);
                    }
                }
            };
            this.myTextRenderer.setBackground(tree.getBackground());
            this.myCheckbox = new JCheckBox();
            this.myCheckbox.setBackground(tree.getBackground());
            this.myEmpty = new JLabel("");
            this.add((Component)this.myCheckbox, "West");
            this.add((Component)((Object)this.myTextRenderer), "Center");
            this.myCheckbox.setVisible(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.invalidate();
            VirtualFile file = VcsStructureChooser.getFile(value);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (file == null) {
                Object uo;
                if (value instanceof DefaultMutableTreeNode && (uo = node.getUserObject()) instanceof String) {
                    this.myColoredRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                    return this.myColoredRenderer;
                }
                return this.myEmpty;
            }
            this.myCheckbox.setVisible(true);
            TreeNodeState state2 = this.mySelectionManager.getState(node);
            this.myCheckbox.setEnabled(TreeNodeState.CLEAR.equals((Object)state2) || TreeNodeState.SELECTED.equals((Object)state2));
            this.myCheckbox.setSelected(!TreeNodeState.CLEAR.equals((Object)state2));
            this.myTextRenderer.getListCellRendererComponent(this.myFictive, file, 0, selected, hasFocus);
            this.revalidate();
            return this;
        }
    }
}

