/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.VcsLogUi;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogQuickSettingsActions
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/VcsLogQuickSettingsActions", "actionPerformed"));
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLogUi logUi = (VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogSettings settings = (VcsLogSettings)ServiceManager.getService((Project)project, VcsLogSettings.class);
        MySettingsActionGroup settingsGroup = new MySettingsActionGroup(settings, logUi);
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", (ActionGroup)settingsGroup);
        int x = 0;
        int y = 0;
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            x = ((MouseEvent)inputEvent).getX();
            y = ((MouseEvent)inputEvent).getY();
        }
        popupMenu.getComponent().show(inputEvent.getComponent(), x, y);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/VcsLogQuickSettingsActions", "update"));
        }
        Project project = e.getProject();
        VcsLogUi logUi = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        e.getPresentation().setEnabledAndVisible(project != null && logUi != null);
    }

    private static class MySettingsActionGroup
    extends ActionGroup {
        private final VcsLogSettings mySettings;
        private final VcsLogUi myUi;

        public MySettingsActionGroup(VcsLogSettings settings, VcsLogUi ui) {
            this.mySettings = settings;
            this.myUi = ui;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new ShowBranchesPanelAction()};
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogQuickSettingsActions$MySettingsActionGroup", "getChildren"));
            }
            return anActionArray;
        }

        private class ShowBranchesPanelAction
        extends ToggleAction
        implements DumbAware {
            public ShowBranchesPanelAction() {
                super("Show Branches Panel");
            }

            public boolean isSelected(AnActionEvent e) {
                return MySettingsActionGroup.this.mySettings.isShowBranchesPanel();
            }

            public void setSelected(AnActionEvent e, boolean state2) {
                MySettingsActionGroup.this.mySettings.setShowBranchesPanel(state2);
                MySettingsActionGroup.this.myUi.setBranchesPanelVisible(state2);
            }
        }
    }
}

