/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.util.BooleanFunction;
import com.intellij.vcs.log.graph.utils.UpdatableIntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.AbstractIntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.IDIntToIntMap;
import org.jetbrains.annotations.NotNull;

public class TreeIntToIntMap
extends AbstractIntToIntMap
implements UpdatableIntToIntMap {
    @NotNull
    private final BooleanFunction<Integer> myThisIsVisible;
    private final int myLongSize;
    private final int myCountLevels;
    private final int[] myTree;

    public static UpdatableIntToIntMap newInstance(@NotNull BooleanFunction<Integer> thisIsVisible, int longSize) {
        if (thisIsVisible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisIsVisible", "com/intellij/vcs/log/graph/utils/impl/TreeIntToIntMap", "newInstance"));
        }
        if (longSize < 0) {
            throw new NegativeArraySizeException("size < 0: " + longSize);
        }
        if (longSize == 0) {
            return IDIntToIntMap.EMPTY;
        }
        int countLevels = longSize == 1 ? 2 : TreeIntToIntMap.countDigits(longSize - 1) + 1;
        int[] emptyTree = new int[1 << countLevels - 1];
        TreeIntToIntMap intToIntMap = new TreeIntToIntMap(thisIsVisible, longSize, countLevels, emptyTree);
        intToIntMap.update(0, longSize - 1);
        return intToIntMap;
    }

    private static int countDigits(int longSize) {
        int count = 0;
        while (longSize != 0) {
            ++count;
            longSize >>= 1;
        }
        return count;
    }

    private TreeIntToIntMap(@NotNull BooleanFunction<Integer> thisIsVisible, int longSize, int countLevels, int[] tree) {
        if (thisIsVisible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisIsVisible", "com/intellij/vcs/log/graph/utils/impl/TreeIntToIntMap", "<init>"));
        }
        this.myThisIsVisible = thisIsVisible;
        this.myLongSize = longSize;
        this.myCountLevels = countLevels;
        this.myTree = tree;
    }

    @Override
    public int shortSize() {
        return this.myTree[1];
    }

    @Override
    public int longSize() {
        return this.myLongSize;
    }

    @Override
    public int getLongIndex(int shortIndex) {
        this.checkShortIndex(shortIndex);
        int node = 1;
        for (int level = 0; level < this.myCountLevels - 1; ++level) {
            int child = node << 1;
            int countInChildNode = this.getCountInNode(child);
            if (countInChildNode > shortIndex) {
                node = child;
                continue;
            }
            node = child + 1;
            shortIndex -= countInChildNode;
        }
        return node - this.myTree.length;
    }

    @Override
    public void update(int startLongIndex, int endLongIndex) {
        this.checkUpdateParameters(startLongIndex, endLongIndex);
        int startNode = startLongIndex + this.myTree.length;
        int endNode = endLongIndex + this.myTree.length;
        int commonNode = startNode >> TreeIntToIntMap.countDigits(startNode ^ endNode);
        this.updateNodeCount(commonNode);
        for (int parent = commonNode >> 1; parent != 0; parent >>= 1) {
            this.myTree[parent] = this.getCountInNode(parent << 1) + this.getCountInNode((parent << 1) + 1);
        }
    }

    private boolean isLastLevel(int node) {
        return node >= this.myTree.length;
    }

    private int updateNodeCount(int node) {
        if (this.isLastLevel(node)) {
            return this.getCountInLastLevel(node);
        }
        int child = node << 1;
        this.myTree[node] = this.updateNodeCount(child) + this.updateNodeCount(child + 1);
        return this.myTree[node];
    }

    private int getCountInLastLevel(int node) {
        if ((node -= this.myTree.length) < this.myLongSize && this.myThisIsVisible.fun((Object)node)) {
            return 1;
        }
        return 0;
    }

    private int getCountInNode(int node) {
        if (this.isLastLevel(node)) {
            return this.getCountInLastLevel(node);
        }
        return this.myTree[node];
    }
}

