/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.visible.adapters;

import com.intellij.util.BooleanFunction;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.LinearGraphWithHiddenNodes;
import com.intellij.vcs.log.graph.api.PrintedLinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.utils.IntToIntMap;
import com.intellij.vcs.log.graph.utils.UpdatableIntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.ListIntToIntMap;
import java.util.AbstractList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphWithHiddenNodesAsPrintedGraph
implements PrintedLinearGraph {
    @NotNull
    protected final GraphLayout myPermanentGraphLayout;
    @NotNull
    protected final LinearGraphWithHiddenNodes myDelegateGraph;
    @NotNull
    protected final UpdatableIntToIntMap myIntToIntMap;

    public GraphWithHiddenNodesAsPrintedGraph(final @NotNull LinearGraphWithHiddenNodes delegateGraph, @NotNull GraphLayout permanentGraphLayout) {
        if (delegateGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateGraph", "com/intellij/vcs/log/graph/impl/visible/adapters/GraphWithHiddenNodesAsPrintedGraph", "<init>"));
        }
        if (permanentGraphLayout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraphLayout", "com/intellij/vcs/log/graph/impl/visible/adapters/GraphWithHiddenNodesAsPrintedGraph", "<init>"));
        }
        this.myPermanentGraphLayout = permanentGraphLayout;
        this.myDelegateGraph = delegateGraph;
        this.myIntToIntMap = ListIntToIntMap.newInstance(new BooleanFunction<Integer>(){

            public boolean fun(Integer integer) {
                return delegateGraph.nodeIsVisible(integer);
            }
        }, delegateGraph.nodesCount());
        this.myDelegateGraph.getListenerController().addListener(new LinearGraphWithHiddenNodes.UpdateListener(){

            @Override
            public void update(int upNodeIndex, int downNodeIndex) {
                GraphWithHiddenNodesAsPrintedGraph.this.myIntToIntMap.update(upNodeIndex, downNodeIndex);
            }
        });
    }

    @Override
    public int getLayoutIndex(int nodeIndex) {
        return this.myPermanentGraphLayout.getLayoutIndex(this.getIndexInPermanentGraph(nodeIndex));
    }

    @Override
    public int getHeadLayoutIndex(int nodeIndex) {
        int headNodeIndex = this.myPermanentGraphLayout.getOneOfHeadNodeIndex(this.getIndexInPermanentGraph(nodeIndex));
        return this.myPermanentGraphLayout.getLayoutIndex(headNodeIndex);
    }

    @Override
    @NotNull
    public GraphNode.Type getNodeType(int nodeIndex) {
        GraphNode.Type type = this.myDelegateGraph.getNodeType(this.getIndexInPermanentGraph(nodeIndex));
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/adapters/GraphWithHiddenNodesAsPrintedGraph", "getNodeType"));
        }
        return type;
    }

    @Override
    @NotNull
    public GraphEdge.Type getEdgeType(int upNodeIndex, int downNodeIndex) {
        int upIndex = this.getIndexInPermanentGraph(upNodeIndex);
        if (downNodeIndex == Integer.MAX_VALUE) {
            GraphEdge.Type type = GraphEdge.Type.USUAL;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/adapters/GraphWithHiddenNodesAsPrintedGraph", "getEdgeType"));
            }
            return type;
        }
        int downIndex = this.getIndexInPermanentGraph(downNodeIndex);
        GraphEdge.Type type = this.myDelegateGraph.getEdgeType(upIndex, downIndex);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/adapters/GraphWithHiddenNodesAsPrintedGraph", "getEdgeType"));
        }
        return type;
    }

    @Override
    public int nodesCount() {
        return this.myIntToIntMap.shortSize();
    }

    protected int getIndexInPermanentGraph(int nodeIndex) {
        return this.myIntToIntMap.getLongIndex(nodeIndex);
    }

    @NotNull
    public IntToIntMap getIntToIntMap() {
        UpdatableIntToIntMap updatableIntToIntMap = this.myIntToIntMap;
        if (updatableIntToIntMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/adapters/GraphWithHiddenNodesAsPrintedGraph", "getIntToIntMap"));
        }
        return updatableIntToIntMap;
    }

    @Override
    @NotNull
    public List<Integer> getUpNodes(int nodeIndex) {
        List<Integer> upDelegateNodes = this.myDelegateGraph.getUpNodes(this.getIndexInPermanentGraph(nodeIndex));
        ShortNodeIndexList shortNodeIndexList = new ShortNodeIndexList(upDelegateNodes);
        if (shortNodeIndexList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/adapters/GraphWithHiddenNodesAsPrintedGraph", "getUpNodes"));
        }
        return shortNodeIndexList;
    }

    @Override
    @NotNull
    public List<Integer> getDownNodes(int nodeIndex) {
        List<Integer> downDelegateNodes = this.myDelegateGraph.getDownNodes(this.getIndexInPermanentGraph(nodeIndex));
        ShortNodeIndexList shortNodeIndexList = new ShortNodeIndexList(downDelegateNodes);
        if (shortNodeIndexList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/adapters/GraphWithHiddenNodesAsPrintedGraph", "getDownNodes"));
        }
        return shortNodeIndexList;
    }

    private class ShortNodeIndexList
    extends AbstractList<Integer> {
        private final List<Integer> longIndexNodes;

        private ShortNodeIndexList(List<Integer> longIndexNodes) {
            this.longIndexNodes = longIndexNodes;
        }

        @Override
        public Integer get(int index) {
            Integer longIndex = this.longIndexNodes.get(index);
            if (longIndex == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return GraphWithHiddenNodesAsPrintedGraph.this.myIntToIntMap.getShortIndex(longIndex);
        }

        @Override
        public int size() {
            return this.longIndexNodes.size();
        }
    }
}

