/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.visible;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CurrentBranches {
    @NotNull
    private final LinearGraph myPermanentGraph;
    @NotNull
    private final Flags myVisibleNodesInBranches;
    @NotNull
    private final DfsUtil myDfsUtil;

    @NotNull
    public static Flags getVisibleNodes(@NotNull LinearGraph permanentGraph, @NotNull Set<Integer> headNodeIndexes) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/graph/impl/visible/CurrentBranches", "getVisibleNodes"));
        }
        if (headNodeIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headNodeIndexes", "com/intellij/vcs/log/graph/impl/visible/CurrentBranches", "getVisibleNodes"));
        }
        assert (!headNodeIndexes.isEmpty());
        CurrentBranches currentBranches = new CurrentBranches(permanentGraph);
        currentBranches.selectAllVisibleNodes(headNodeIndexes);
        Flags flags = currentBranches.myVisibleNodesInBranches;
        if (flags == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/CurrentBranches", "getVisibleNodes"));
        }
        return flags;
    }

    public CurrentBranches(@NotNull LinearGraph permanentGraph) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/graph/impl/visible/CurrentBranches", "<init>"));
        }
        this.myDfsUtil = new DfsUtil();
        this.myPermanentGraph = permanentGraph;
        this.myVisibleNodesInBranches = new BitSetFlags(permanentGraph.nodesCount(), false);
    }

    private void selectAllVisibleNodes(@NotNull Set<Integer> startedNodes) {
        if (startedNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startedNodes", "com/intellij/vcs/log/graph/impl/visible/CurrentBranches", "selectAllVisibleNodes"));
        }
        for (int startNode : startedNodes) {
            this.myVisibleNodesInBranches.set(startNode, true);
            this.myDfsUtil.nodeDfsIterator(startNode, new DfsUtil.NextNode(){

                @Override
                public int fun(int currentNode) {
                    for (int downNode : CurrentBranches.this.myPermanentGraph.getDownNodes(currentNode)) {
                        if (downNode == Integer.MAX_VALUE || CurrentBranches.this.myVisibleNodesInBranches.get(downNode)) continue;
                        CurrentBranches.this.myVisibleNodesInBranches.set(downNode, true);
                        return downNode;
                    }
                    return -1;
                }
            });
        }
    }
}

