/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.util.containers.HashSet;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.api.LinearGraphWithCommitInfo;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.impl.print.AbstractPrintElementsManager;
import com.intellij.vcs.log.graph.impl.visible.FragmentGenerator;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.Flags;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PrintElementsManagerImpl<CommitId>
extends AbstractPrintElementsManager<CommitId> {
    @NotNull
    private final FragmentGenerator myFragmentGenerator;
    @NotNull
    private final DfsUtil myDfsUtil;

    public PrintElementsManagerImpl(@NotNull LinearGraphWithCommitInfo<CommitId> printedLinearGraph, @NotNull FragmentGenerator fragmentGenerator, @NotNull GraphColorManager<CommitId> colorManager) {
        if (printedLinearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printedLinearGraph", "com/intellij/vcs/log/graph/impl/print/PrintElementsManagerImpl", "<init>"));
        }
        if (fragmentGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragmentGenerator", "com/intellij/vcs/log/graph/impl/print/PrintElementsManagerImpl", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/graph/impl/print/PrintElementsManagerImpl", "<init>"));
        }
        super(printedLinearGraph, colorManager);
        this.myDfsUtil = new DfsUtil();
        this.myFragmentGenerator = fragmentGenerator;
    }

    private void enableAllRelativeNodes(final @NotNull Flags flags, int rowIndex) {
        if (flags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flags", "com/intellij/vcs/log/graph/impl/print/PrintElementsManagerImpl", "enableAllRelativeNodes"));
        }
        flags.set(rowIndex, true);
        this.myDfsUtil.nodeDfsIterator(rowIndex, new DfsUtil.NextNode(){

            @Override
            public int fun(int currentNode) {
                for (int downNode : PrintElementsManagerImpl.this.myPrintedLinearGraph.getDownNodes(currentNode)) {
                    if (downNode == Integer.MAX_VALUE || flags.get(downNode)) continue;
                    flags.set(downNode, true);
                    return downNode;
                }
                return -1;
            }
        });
        this.myDfsUtil.nodeDfsIterator(rowIndex, new DfsUtil.NextNode(){

            @Override
            public int fun(int currentNode) {
                for (int upNode : PrintElementsManagerImpl.this.myPrintedLinearGraph.getUpNodes(currentNode)) {
                    if (flags.get(upNode)) continue;
                    flags.set(upNode, true);
                    return upNode;
                }
                return -1;
            }
        });
    }

    @Override
    @NotNull
    protected Set<Integer> getSelectedNodes(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphElement", "com/intellij/vcs/log/graph/impl/print/PrintElementsManagerImpl", "getSelectedNodes"));
        }
        FragmentGenerator.GraphFragment fragment = this.myFragmentGenerator.getPartLongFragment(graphElement);
        if (fragment == null) {
            Set<Integer> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementsManagerImpl", "getSelectedNodes"));
            }
            return set;
        }
        HashSet selectedNodes = new HashSet();
        selectedNodes.add(fragment.upNodeIndex);
        selectedNodes.add(fragment.downNodeIndex);
        this.myDfsUtil.nodeDfsIterator(fragment.upNodeIndex, new DfsUtil.NextNode((Set)selectedNodes){
            final /* synthetic */ Set val$selectedNodes;
            {
                this.val$selectedNodes = set;
            }

            @Override
            public int fun(int currentNode) {
                for (int downNode : PrintElementsManagerImpl.this.myPrintedLinearGraph.getDownNodes(currentNode)) {
                    if (!this.val$selectedNodes.add(downNode)) continue;
                    return downNode;
                }
                return -1;
            }
        });
        HashSet hashSet = selectedNodes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementsManagerImpl", "getSelectedNodes"));
        }
        return hashSet;
    }
}

