/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.graph.SimplePrintElement;
import com.intellij.vcs.log.graph.api.PrintedLinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.printer.PrintElementsManager;
import com.intellij.vcs.log.graph.impl.print.AbstractPrintElementGenerator;
import com.intellij.vcs.log.graph.impl.print.EdgesInRowGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PrintElementGeneratorImpl
extends AbstractPrintElementGenerator {
    private static final int LONG_EDGE_SIZE = 30;
    private static final int LONG_EDGE_PART_SIZE = 1;
    private static final int VERY_LONG_EDGE_SIZE = 1000;
    private static final int VERY_LONG_EDGE_PART_SIZE = 250;
    private static final int CACHE_SIZE = 100;
    private static final boolean SHOW_ARROW_WHEN_SHOW_LONG_EDGES = true;
    @NotNull
    private final SLRUMap<Integer, List<GraphElement>> cache;
    @NotNull
    private final EdgesInRowGenerator myEdgesInRowGenerator;
    @NotNull
    private final GraphElementComparator myGraphElementComparator;
    private boolean showLongEdges;

    public PrintElementGeneratorImpl(@NotNull PrintedLinearGraph graph, @NotNull PrintElementsManager printElementsManager) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "<init>"));
        }
        if (printElementsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementsManager", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "<init>"));
        }
        super(graph, printElementsManager);
        this.cache = new SLRUMap(100, 200);
        this.showLongEdges = false;
        this.myEdgesInRowGenerator = new EdgesInRowGenerator(graph);
        this.myGraphElementComparator = new GraphElementComparator();
    }

    @NotNull
    protected List<AbstractPrintElementGenerator.ShortEdge> getDownShortEdges(int rowIndex) {
        Function<GraphEdge, Integer> endPosition = this.createEndPositionFunction(rowIndex);
        ArrayList<AbstractPrintElementGenerator.ShortEdge> result = new ArrayList<AbstractPrintElementGenerator.ShortEdge>();
        List<GraphElement> visibleElements = this.getSortedVisibleElementsInRow(rowIndex);
        for (int startPosition = 0; startPosition < visibleElements.size(); ++startPosition) {
            GraphEdge edge;
            int endPos;
            GraphElement element = visibleElements.get(startPosition);
            if (element instanceof GraphNode) {
                for (GraphEdge edge2 : this.myEdgesInRowGenerator.createDownEdges(((GraphNode)element).getNodeIndex())) {
                    int endPos2 = (Integer)endPosition.fun((Object)edge2);
                    if (endPos2 == -1) continue;
                    result.add(new AbstractPrintElementGenerator.ShortEdge(edge2, startPosition, endPos2));
                }
            }
            if (!(element instanceof GraphEdge) || (endPos = ((Integer)endPosition.fun((Object)(edge = (GraphEdge)element))).intValue()) == -1) continue;
            result.add(new AbstractPrintElementGenerator.ShortEdge(edge, startPosition, endPos));
        }
        ArrayList<AbstractPrintElementGenerator.ShortEdge> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getDownShortEdges"));
        }
        return arrayList;
    }

    @NotNull
    private Function<GraphEdge, Integer> createEndPositionFunction(int visibleRowIndex) {
        List<GraphElement> visibleElementsInNextRow = this.getSortedVisibleElementsInRow(visibleRowIndex + 1);
        final HashMap<GraphElement, Integer> toPosition = new HashMap<GraphElement, Integer>();
        for (int position = 0; position < visibleElementsInNextRow.size(); ++position) {
            toPosition.put(visibleElementsInNextRow.get(position), position);
        }
        Function<GraphEdge, Integer> function = new Function<GraphEdge, Integer>(){

            public Integer fun(GraphEdge edge) {
                int downNodeVisibleIndex;
                Integer position = (Integer)toPosition.get(edge);
                if (position == null && (downNodeVisibleIndex = edge.getDownNodeIndex()) != Integer.MAX_VALUE) {
                    position = (Integer)toPosition.get(new GraphNode(downNodeVisibleIndex));
                }
                if (position == null) {
                    return -1;
                }
                return position;
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "createEndPositionFunction"));
        }
        return function;
    }

    @NotNull
    protected List<AbstractPrintElementGenerator.SimpleRowElement> getSimpleRowElements(int visibleRowIndex) {
        SmartList result = new SmartList();
        int position = 0;
        for (GraphElement element : this.getSortedVisibleElementsInRow(visibleRowIndex)) {
            if (element instanceof GraphNode) {
                result.add(new AbstractPrintElementGenerator.SimpleRowElement(element, SimplePrintElement.Type.NODE, position));
            }
            if (element instanceof GraphEdge) {
                GraphEdge edge = (GraphEdge)element;
                int edgeSize = edge.getDownNodeIndex() - edge.getUpNodeIndex();
                int upOffset = visibleRowIndex - edge.getUpNodeIndex();
                int downOffset = edge.getDownNodeIndex() - visibleRowIndex;
                if (edgeSize >= 30) {
                    if (!this.showLongEdges) {
                        PrintElementGeneratorImpl.addArrowIfNeeded((List<AbstractPrintElementGenerator.SimpleRowElement>)result, position, edge, upOffset, downOffset, 1);
                    } else {
                        PrintElementGeneratorImpl.addArrowIfNeeded((List<AbstractPrintElementGenerator.SimpleRowElement>)result, position, edge, upOffset, downOffset, 1);
                        if (edgeSize >= 1000) {
                            PrintElementGeneratorImpl.addArrowIfNeeded((List<AbstractPrintElementGenerator.SimpleRowElement>)result, position, edge, upOffset, downOffset, 250);
                        }
                    }
                }
            }
            ++position;
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getSimpleRowElements"));
        }
        return smartList;
    }

    private static void addArrowIfNeeded(List<AbstractPrintElementGenerator.SimpleRowElement> result, int position, GraphEdge edge, int upOffset, int downOffset, int edgePartSize) {
        if (upOffset == edgePartSize) {
            result.add(new AbstractPrintElementGenerator.SimpleRowElement(edge, SimplePrintElement.Type.DOWN_ARROW, position));
        }
        if (downOffset == edgePartSize) {
            result.add(new AbstractPrintElementGenerator.SimpleRowElement(edge, SimplePrintElement.Type.UP_ARROW, position));
        }
    }

    @Override
    public boolean areLongEdgesHidden() {
        return !this.showLongEdges;
    }

    @Override
    public void setLongEdgesHidden(boolean longEdgesHidden) {
        this.showLongEdges = !longEdgesHidden;
        this.invalidate();
    }

    @Override
    public void invalidate() {
        this.myEdgesInRowGenerator.invalidate();
        this.cache.clear();
    }

    private int getLongEdgeSize() {
        if (this.showLongEdges) {
            return 1000;
        }
        return 30;
    }

    private int getEdgeShowPartSize() {
        if (this.showLongEdges) {
            return 250;
        }
        return 1;
    }

    private boolean edgeIsVisibleInRow(@NotNull GraphEdge edge, int visibleRowIndex) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "edgeIsVisibleInRow"));
        }
        int edgeSize = edge.getDownNodeIndex() - edge.getUpNodeIndex();
        if (edgeSize < this.getLongEdgeSize()) {
            return true;
        }
        return visibleRowIndex - edge.getUpNodeIndex() <= this.getEdgeShowPartSize() || edge.getDownNodeIndex() - visibleRowIndex <= this.getEdgeShowPartSize();
    }

    @NotNull
    private List<GraphElement> getSortedVisibleElementsInRow(int rowIndex) {
        List graphElements = (List)this.cache.get((Object)rowIndex);
        if (graphElements != null) {
            List list = graphElements;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getSortedVisibleElementsInRow"));
            }
            return list;
        }
        ArrayList<GraphElement> result = new ArrayList<GraphElement>();
        result.add(new GraphNode(rowIndex));
        for (GraphEdge edge : this.myEdgesInRowGenerator.getEdgesInRow(rowIndex)) {
            if (!this.edgeIsVisibleInRow(edge, rowIndex)) continue;
            result.add(edge);
        }
        Collections.sort(result, this.myGraphElementComparator);
        this.cache.put((Object)rowIndex, result);
        ArrayList<GraphElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getSortedVisibleElementsInRow"));
        }
        return arrayList;
    }

    private class GraphElementComparator
    implements Comparator<GraphElement> {
        private GraphElementComparator() {
        }

        @Override
        public int compare(@NotNull GraphElement o1, @NotNull GraphElement o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl$GraphElementComparator", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl$GraphElementComparator", "compare"));
            }
            if (o1 instanceof GraphEdge && o2 instanceof GraphEdge) {
                int upNodeIndex2;
                int upNodeIndex1 = ((GraphEdge)o1).getUpNodeIndex();
                if (upNodeIndex1 == (upNodeIndex2 = ((GraphEdge)o2).getUpNodeIndex())) {
                    int downNodeIndex1 = ((GraphEdge)o1).getDownNodeIndex();
                    int downNodeIndex2 = ((GraphEdge)o2).getDownNodeIndex();
                    if (downNodeIndex1 == Integer.MAX_VALUE) {
                        return 1;
                    }
                    if (downNodeIndex2 == Integer.MAX_VALUE) {
                        return -1;
                    }
                    if (this.getLayoutIndex(downNodeIndex1) != this.getLayoutIndex(downNodeIndex2)) {
                        return this.getLayoutIndex(downNodeIndex1) - this.getLayoutIndex(downNodeIndex2);
                    }
                    return downNodeIndex1 - downNodeIndex2;
                }
                if (upNodeIndex1 < upNodeIndex2) {
                    return this.compare(o1, new GraphNode(upNodeIndex2));
                }
                return this.compare(new GraphNode(upNodeIndex1), o2);
            }
            if (o1 instanceof GraphEdge && o2 instanceof GraphNode) {
                return this.compare2((GraphEdge)o1, (GraphNode)o2);
            }
            if (o1 instanceof GraphNode && o2 instanceof GraphEdge) {
                return -this.compare2((GraphEdge)o2, (GraphNode)o1);
            }
            assert (false);
            return 0;
        }

        private int compare2(@NotNull GraphEdge edge, @NotNull GraphNode node) {
            int upEdgeLI;
            if (edge == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl$GraphElementComparator", "compare2"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl$GraphElementComparator", "compare2"));
            }
            int downEdgeLI = upEdgeLI = this.getLayoutIndex(edge.getUpNodeIndex());
            if (edge.getDownNodeIndex() != Integer.MAX_VALUE) {
                downEdgeLI = this.getLayoutIndex(edge.getDownNodeIndex());
            }
            int nodeLI = this.getLayoutIndex(node.getNodeIndex());
            if (Math.max(upEdgeLI, downEdgeLI) != nodeLI) {
                return Math.max(upEdgeLI, downEdgeLI) - nodeLI;
            }
            return edge.getUpNodeIndex() - node.getNodeIndex();
        }

        private int getLayoutIndex(int nodeIndex) {
            return PrintElementGeneratorImpl.this.myPrintedLinearGraph.getLayoutIndex(nodeIndex);
        }
    }
}

