/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.SimplePrintElement;
import com.intellij.vcs.log.graph.api.LinearGraphWithCommitInfo;
import com.intellij.vcs.log.graph.api.LinearGraphWithElementInfo;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.printer.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.api.printer.PrintElementsManager;
import java.awt.Cursor;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPrintElementsManager<CommitId>
implements PrintElementsManager {
    private static final Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    @NotNull
    protected final LinearGraphWithCommitInfo<CommitId> myPrintedLinearGraph;
    @NotNull
    protected final GraphColorManager<CommitId> myColorManager;
    @Nullable
    private PrintElementWithGraphElement mySpecialSelectedPrintElement;
    @NotNull
    private Set<Integer> mySelectedNodes;

    @Nullable
    public static GraphEdge containedCollapsedEdge(@NotNull GraphElement element, @NotNull LinearGraphWithElementInfo graphWithElementsInfo) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementsManager", "containedCollapsedEdge"));
        }
        if (graphWithElementsInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphWithElementsInfo", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementsManager", "containedCollapsedEdge"));
        }
        if (element instanceof GraphEdge) {
            GraphEdge edge = (GraphEdge)element;
            if (edge.getType() == GraphEdge.Type.HIDE) {
                return edge;
            }
        } else {
            int nodeIndex = ((GraphNode)element).getNodeIndex();
            for (int upNode : graphWithElementsInfo.getUpNodes(nodeIndex)) {
                if (graphWithElementsInfo.getEdgeType(upNode, nodeIndex) != GraphEdge.Type.HIDE) continue;
                return new GraphEdge(upNode, nodeIndex, GraphEdge.Type.HIDE);
            }
            for (int downNode : graphWithElementsInfo.getDownNodes(nodeIndex)) {
                if (graphWithElementsInfo.getEdgeType(nodeIndex, downNode) != GraphEdge.Type.HIDE) continue;
                return new GraphEdge(nodeIndex, downNode, GraphEdge.Type.HIDE);
            }
        }
        return null;
    }

    protected AbstractPrintElementsManager(@NotNull LinearGraphWithCommitInfo<CommitId> printedLinearGraph, @NotNull GraphColorManager<CommitId> colorManager) {
        if (printedLinearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printedLinearGraph", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementsManager", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementsManager", "<init>"));
        }
        this.mySpecialSelectedPrintElement = null;
        this.mySelectedNodes = Collections.emptySet();
        this.myPrintedLinearGraph = printedLinearGraph;
        this.myColorManager = colorManager;
    }

    @Override
    public boolean elementIsSelected(@NotNull PrintElementWithGraphElement printElement) {
        if (printElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElement", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementsManager", "elementIsSelected"));
        }
        if (this.mySpecialSelectedPrintElement != null && printElement.equals(this.mySpecialSelectedPrintElement)) {
            return true;
        }
        GraphElement graphElement = printElement.getGraphElement();
        if (graphElement instanceof GraphNode) {
            return this.mySelectedNodes.contains(((GraphNode)graphElement).getNodeIndex());
        }
        GraphEdge edge = (GraphEdge)graphElement;
        return this.mySelectedNodes.contains(edge.getUpNodeIndex()) && this.mySelectedNodes.contains(edge.getDownNodeIndex());
    }

    @Override
    @Nullable
    public Cursor performOverElement(@Nullable PrintElementWithGraphElement printElement) {
        GraphEdge graphEdge;
        if (printElement instanceof SimplePrintElement) {
            SimplePrintElement.Type elementType = ((SimplePrintElement)printElement).getType();
            if (elementType == SimplePrintElement.Type.UP_ARROW || elementType == SimplePrintElement.Type.DOWN_ARROW) {
                this.mySelectedNodes = Collections.emptySet();
                this.mySpecialSelectedPrintElement = printElement;
                return HAND_CURSOR;
            }
        } else {
            this.mySpecialSelectedPrintElement = null;
        }
        this.mySelectedNodes = printElement != null ? ((graphEdge = AbstractPrintElementsManager.containedCollapsedEdge(printElement.getGraphElement(), this.myPrintedLinearGraph)) != null && this.allowSelectCollapsedEdge(graphEdge) ? ContainerUtil.set((Object[])new Integer[]{graphEdge.getUpNodeIndex(), graphEdge.getDownNodeIndex()}) : this.getSelectedNodes(printElement.getGraphElement())) : Collections.emptySet();
        return DEFAULT_CURSOR;
    }

    @Override
    public int getColorId(@NotNull GraphElement element) {
        int downNodeIndex;
        int upNodeIndex;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementsManager", "getColorId"));
        }
        if (element instanceof GraphNode) {
            downNodeIndex = upNodeIndex = ((GraphNode)element).getNodeIndex();
        } else {
            GraphEdge edge = (GraphEdge)element;
            upNodeIndex = edge.getUpNodeIndex();
            downNodeIndex = edge.getDownNodeIndex();
        }
        if (downNodeIndex == Integer.MAX_VALUE) {
            downNodeIndex = upNodeIndex;
        }
        int upLayoutIndex = this.myPrintedLinearGraph.getLayoutIndex(upNodeIndex);
        int downLayoutIndex = this.myPrintedLinearGraph.getLayoutIndex(downNodeIndex);
        CommitId headCommitId = this.myPrintedLinearGraph.getOneOfHeads(upNodeIndex);
        if (upLayoutIndex != downLayoutIndex) {
            return this.myColorManager.getColorOfFragment(headCommitId, Math.max(upLayoutIndex, downLayoutIndex));
        }
        if (upLayoutIndex == this.myPrintedLinearGraph.getHeadLayoutIndex(upNodeIndex)) {
            return this.myColorManager.getColorOfBranch(headCommitId);
        }
        return this.myColorManager.getColorOfFragment(headCommitId, upLayoutIndex);
    }

    @NotNull
    protected abstract Set<Integer> getSelectedNodes(@NotNull GraphElement var1);

    protected boolean allowSelectCollapsedEdge(@NotNull GraphEdge graphEdge) {
        if (graphEdge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphEdge", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementsManager", "allowSelectCollapsedEdge"));
        }
        return true;
    }
}

