/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.bek;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DelegatedPermanentGraphInfo<CommitId>
implements PermanentGraphInfo<CommitId> {
    @NotNull
    private final PermanentGraphInfo<CommitId> myDelegateInfo;
    @NotNull
    private final BekIntMap myBekIntMap;

    public DelegatedPermanentGraphInfo(@NotNull PermanentGraphInfo<CommitId> delegateInfo, @NotNull BekIntMap bekIntMap) {
        if (delegateInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateInfo", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo", "<init>"));
        }
        if (bekIntMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bekIntMap", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo", "<init>"));
        }
        this.myDelegateInfo = delegateInfo;
        this.myBekIntMap = bekIntMap;
    }

    @Override
    @NotNull
    public PermanentCommitsInfo<CommitId> getPermanentCommitsInfo() {
        final PermanentCommitsInfo<CommitId> commitsInfo = this.myDelegateInfo.getPermanentCommitsInfo();
        PermanentCommitsInfo permanentCommitsInfo = new PermanentCommitsInfo<CommitId>(){

            @Override
            @NotNull
            public CommitId getCommitId(int permanentNodeIndex) {
                Object CommitId = commitsInfo.getCommitId(DelegatedPermanentGraphInfo.this.myBekIntMap.getUsualIndex(permanentNodeIndex));
                if (CommitId == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo$1", "getCommitId"));
                }
                return CommitId;
            }

            @Override
            public long getTimestamp(int permanentNodeIndex) {
                return commitsInfo.getTimestamp(DelegatedPermanentGraphInfo.this.myBekIntMap.getUsualIndex(permanentNodeIndex));
            }

            @Override
            public int getPermanentNodeIndex(@NotNull CommitId commitId) {
                if (commitId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo$1", "getPermanentNodeIndex"));
                }
                int usualIndex = commitsInfo.getPermanentNodeIndex(commitId);
                return DelegatedPermanentGraphInfo.this.myBekIntMap.getBekIndex(usualIndex);
            }

            @Override
            @NotNull
            public Set<Integer> convertToCommitIndexes(Collection<CommitId> heads) {
                Set<Integer> usualIndexes = commitsInfo.convertToCommitIndexes(heads);
                Set set = ContainerUtil.map2Set(usualIndexes, (Function)new Function<Integer, Integer>(){

                    public Integer fun(Integer integer) {
                        return DelegatedPermanentGraphInfo.this.myBekIntMap.getBekIndex(integer);
                    }
                });
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo$1", "convertToCommitIndexes"));
                }
                return set;
            }
        };
        if (permanentCommitsInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo", "getPermanentCommitsInfo"));
        }
        return permanentCommitsInfo;
    }

    @Override
    @NotNull
    public LinearGraph getPermanentLinearGraph() {
        final LinearGraph linearGraph = this.myDelegateInfo.getPermanentLinearGraph();
        LinearGraph linearGraph2 = new LinearGraph(){

            @Override
            public int nodesCount() {
                return linearGraph.nodesCount();
            }

            @NotNull
            private List<Integer> convertToBekIndexes(@NotNull List<Integer> usualIndexes) {
                if (usualIndexes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usualIndexes", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo$2", "convertToBekIndexes"));
                }
                List list = ContainerUtil.map(usualIndexes, (Function)new Function<Integer, Integer>(){

                    public Integer fun(Integer integer) {
                        return DelegatedPermanentGraphInfo.this.myBekIntMap.getBekIndex(integer);
                    }
                });
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo$2", "convertToBekIndexes"));
                }
                return list;
            }

            @Override
            @NotNull
            public List<Integer> getUpNodes(int nodeIndex) {
                List<Integer> list = this.convertToBekIndexes(linearGraph.getUpNodes(DelegatedPermanentGraphInfo.this.myBekIntMap.getUsualIndex(nodeIndex)));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo$2", "getUpNodes"));
                }
                return list;
            }

            @Override
            @NotNull
            public List<Integer> getDownNodes(int nodeIndex) {
                List<Integer> list = this.convertToBekIndexes(linearGraph.getDownNodes(DelegatedPermanentGraphInfo.this.myBekIntMap.getUsualIndex(nodeIndex)));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo$2", "getDownNodes"));
                }
                return list;
            }
        };
        if (linearGraph2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo", "getPermanentLinearGraph"));
        }
        return linearGraph2;
    }

    @Override
    @NotNull
    public GraphLayout getPermanentGraphLayout() {
        final GraphLayout graphLayout = this.myDelegateInfo.getPermanentGraphLayout();
        GraphLayout graphLayout2 = new GraphLayout(){

            @Override
            public int getLayoutIndex(int nodeIndex) {
                return graphLayout.getLayoutIndex(DelegatedPermanentGraphInfo.this.myBekIntMap.getUsualIndex(nodeIndex));
            }

            @Override
            public int getOneOfHeadNodeIndex(int nodeIndex) {
                int usualIndex = graphLayout.getOneOfHeadNodeIndex(DelegatedPermanentGraphInfo.this.myBekIntMap.getUsualIndex(nodeIndex));
                return DelegatedPermanentGraphInfo.this.myBekIntMap.getBekIndex(usualIndex);
            }
        };
        if (graphLayout2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo", "getPermanentGraphLayout"));
        }
        return graphLayout2;
    }

    @Override
    @NotNull
    public Condition<Integer> getNotCollapsedNodes() {
        final Condition<Integer> notCollapsedNodes = this.myDelegateInfo.getNotCollapsedNodes();
        Condition<Integer> condition = new Condition<Integer>(){

            public boolean value(Integer bekIndex) {
                return notCollapsedNodes.value((Object)DelegatedPermanentGraphInfo.this.myBekIntMap.getUsualIndex(bekIndex));
            }
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo", "getNotCollapsedNodes"));
        }
        return condition;
    }

    @Override
    @NotNull
    public GraphColorManager<CommitId> getGraphColorManager() {
        GraphColorManager<CommitId> graphColorManager = this.myDelegateInfo.getGraphColorManager();
        if (graphColorManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo", "getGraphColorManager"));
        }
        return graphColorManager;
    }

    @Override
    @NotNull
    public Map<CommitId, GraphCommit<CommitId>> getCommitsWithNotLoadParent() {
        Map<CommitId, GraphCommit<CommitId>> map = this.myDelegateInfo.getCommitsWithNotLoadParent();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/bek/DelegatedPermanentGraphInfo", "getCommitsWithNotLoadParent"));
        }
        return map;
    }
}

