/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.bek;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.vcs.log.graph.api.LinearGraph;
import org.jetbrains.annotations.NotNull;

public class BekChecker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.vcs.log.graph.impl.facade.bek.BekChecker");

    public static boolean checkLinearGraph(@NotNull LinearGraph linearGraph) {
        if (linearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraph", "com/intellij/vcs/log/graph/impl/facade/bek/BekChecker", "checkLinearGraph"));
        }
        for (int i = 0; i < linearGraph.nodesCount(); ++i) {
            for (int downNode : linearGraph.getDownNodes(i)) {
                if (downNode > i) continue;
                LOG.error("Illegal node: " + i + ", with downNode: " + downNode);
            }
            for (int upNode : linearGraph.getUpNodes(i)) {
                if (upNode < i) continue;
                LOG.error("Illegal node: " + i + ", with upNode: " + upNode);
            }
        }
        return true;
    }
}

