/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.openapi.util.Condition;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.api.printer.PrintElementsManager;
import com.intellij.vcs.log.graph.impl.facade.AbstractVisibleGraph;
import com.intellij.vcs.log.graph.impl.print.AbstractPrintElementsManager;
import com.intellij.vcs.log.graph.impl.print.PrintElementsManagerImpl;
import com.intellij.vcs.log.graph.impl.visible.CollapsedGraphWithHiddenNodes;
import com.intellij.vcs.log.graph.impl.visible.FragmentGenerator;
import com.intellij.vcs.log.graph.impl.visible.adapters.GraphWithHiddenNodesAsGraphWithCommitInfo;
import com.intellij.vcs.log.graph.impl.visible.adapters.LinearGraphAsGraphWithHiddenNodes;
import com.intellij.vcs.log.graph.utils.IntToIntMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollapsedVisibleGraph<CommitId>
extends AbstractVisibleGraph<CommitId> {
    @NotNull
    private final CollapsedGraphWithHiddenNodes myCollapsedGraph;
    @NotNull
    private final FragmentGenerator myFragmentGeneratorForPrinterGraph;
    @NotNull
    private final IntToIntMap myIntToIntMap;
    @NotNull
    private final PermanentGraphInfo<CommitId> myPermanentGraph;

    @NotNull
    public static <CommitId> CollapsedVisibleGraph<CommitId> newInstance(@NotNull PermanentGraphInfo<CommitId> permanentGraph, @Nullable Set<CommitId> heads) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/graph/impl/facade/CollapsedVisibleGraph", "newInstance"));
        }
        LinearGraphAsGraphWithHiddenNodes branchesGraph = CollapsedVisibleGraph.createBranchesGraph(permanentGraph, heads);
        CollapsedGraphWithHiddenNodes collapsedGraph = new CollapsedGraphWithHiddenNodes(branchesGraph);
        final GraphWithHiddenNodesAsGraphWithCommitInfo<CommitId> graphWithCommitInfo = new GraphWithHiddenNodesAsGraphWithCommitInfo<CommitId>(collapsedGraph, permanentGraph.getPermanentGraphLayout(), permanentGraph.getPermanentCommitsInfo());
        final Condition<Integer> notCollapsedNodes = permanentGraph.getNotCollapsedNodes();
        FragmentGenerator fragmentGeneratorForPrinterGraph = new FragmentGenerator(graphWithCommitInfo, new Condition<Integer>(){

            public boolean value(Integer integer) {
                int longIndex = graphWithCommitInfo.getIntToIntMap().getLongIndex(integer);
                return notCollapsedNodes.value((Object)longIndex);
            }
        });
        PrintElementsManagerImpl<CommitId> printElementsManager = new PrintElementsManagerImpl<CommitId>(graphWithCommitInfo, fragmentGeneratorForPrinterGraph, permanentGraph.getGraphColorManager());
        CollapsedVisibleGraph<CommitId> collapsedVisibleGraph = new CollapsedVisibleGraph<CommitId>(graphWithCommitInfo, collapsedGraph, printElementsManager, fragmentGeneratorForPrinterGraph, permanentGraph);
        if (collapsedVisibleGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/CollapsedVisibleGraph", "newInstance"));
        }
        return collapsedVisibleGraph;
    }

    private CollapsedVisibleGraph(@NotNull GraphWithHiddenNodesAsGraphWithCommitInfo<CommitId> graphWithCommitInfo, @NotNull CollapsedGraphWithHiddenNodes collapsedGraph, @NotNull PrintElementsManager printElementsManager, @NotNull FragmentGenerator fragmentGeneratorForPrinterGraph, @NotNull PermanentGraphInfo<CommitId> permanentGraph) {
        if (graphWithCommitInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphWithCommitInfo", "com/intellij/vcs/log/graph/impl/facade/CollapsedVisibleGraph", "<init>"));
        }
        if (collapsedGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collapsedGraph", "com/intellij/vcs/log/graph/impl/facade/CollapsedVisibleGraph", "<init>"));
        }
        if (printElementsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementsManager", "com/intellij/vcs/log/graph/impl/facade/CollapsedVisibleGraph", "<init>"));
        }
        if (fragmentGeneratorForPrinterGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragmentGeneratorForPrinterGraph", "com/intellij/vcs/log/graph/impl/facade/CollapsedVisibleGraph", "<init>"));
        }
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/graph/impl/facade/CollapsedVisibleGraph", "<init>"));
        }
        super(graphWithCommitInfo, permanentGraph.getCommitsWithNotLoadParent(), printElementsManager);
        this.myCollapsedGraph = collapsedGraph;
        this.myFragmentGeneratorForPrinterGraph = fragmentGeneratorForPrinterGraph;
        this.myPermanentGraph = permanentGraph;
        this.myIntToIntMap = graphWithCommitInfo.getIntToIntMap();
    }

    @Override
    protected void setLinearBranchesExpansion(boolean collapse) {
        if (!collapse) {
            this.myCollapsedGraph.expandAll();
        } else {
            FragmentGenerator fragmentGenerator = new FragmentGenerator(this.myCollapsedGraph, this.myPermanentGraph.getNotCollapsedNodes());
            for (int i = 0; i < this.myCollapsedGraph.nodesCount(); ++i) {
                FragmentGenerator.GraphFragment longDownFragment;
                if (!this.myCollapsedGraph.nodeIsVisible(i) || (longDownFragment = fragmentGenerator.getLongDownFragment(i)) == null) continue;
                this.myCollapsedGraph.fastCollapse(longDownFragment.upNodeIndex, longDownFragment.downNodeIndex);
            }
            this.myCollapsedGraph.callListeners();
        }
    }

    @Override
    @NotNull
    protected GraphAnswer<CommitId> clickByElement(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphElement", "com/intellij/vcs/log/graph/impl/facade/CollapsedVisibleGraph", "clickByElement"));
        }
        GraphEdge graphEdge = AbstractPrintElementsManager.containedCollapsedEdge(graphElement, this.myLinearGraphWithCommitInfo);
        if (graphEdge != null) {
            int upShortIndex = this.myIntToIntMap.getLongIndex(graphEdge.getUpNodeIndex());
            int downShortIndex = this.myIntToIntMap.getLongIndex(graphEdge.getDownNodeIndex());
            this.myCollapsedGraph.expand(upShortIndex, downShortIndex);
            GraphAnswer graphAnswer = this.createJumpAnswer(graphEdge.getUpNodeIndex());
            if (graphAnswer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/CollapsedVisibleGraph", "clickByElement"));
            }
            return graphAnswer;
        }
        FragmentGenerator.GraphFragment relativeFragment = this.myFragmentGeneratorForPrinterGraph.getLongFragment(graphElement);
        if (relativeFragment != null) {
            int upShortIndex = this.myIntToIntMap.getLongIndex(relativeFragment.upNodeIndex);
            int downShortIndex = this.myIntToIntMap.getLongIndex(relativeFragment.downNodeIndex);
            this.myCollapsedGraph.collapse(upShortIndex, downShortIndex);
            GraphAnswer graphAnswer = this.createJumpAnswer(relativeFragment.upNodeIndex);
            if (graphAnswer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/CollapsedVisibleGraph", "clickByElement"));
            }
            return graphAnswer;
        }
        AbstractVisibleGraph.GraphAnswerImpl graphAnswerImpl = this.COMMIT_ID_GRAPH_ANSWER;
        if (graphAnswerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/CollapsedVisibleGraph", "clickByElement"));
        }
        return graphAnswerImpl;
    }
}

