/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.api.elements;

import com.intellij.vcs.log.graph.api.elements.GraphElement;
import org.jetbrains.annotations.NotNull;

public final class GraphNode
implements GraphElement {
    private final int myNodeIndex;
    @NotNull
    private final Type myType;

    public GraphNode(int nodeIndex) {
        this(nodeIndex, Type.USUAL);
    }

    public GraphNode(int nodeIndex, @NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/api/elements/GraphNode", "<init>"));
        }
        this.myNodeIndex = nodeIndex;
        this.myType = type;
    }

    public int getNodeIndex() {
        return this.myNodeIndex;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/api/elements/GraphNode", "getType"));
        }
        return type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphNode graphNode = (GraphNode)o;
        if (this.myNodeIndex != graphNode.myNodeIndex) {
            return false;
        }
        return this.myType == graphNode.myType;
    }

    public int hashCode() {
        int result = this.myNodeIndex;
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    public static enum Type {
        USUAL;

    }
}

