/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Vcs.Log.UiProperties", storages={@Storage(file="$WORKSPACE_FILE$")})
public class VcsLogUiProperties
implements PersistentStateComponent<State> {
    private static final int RECENTLY_FILTERED_USERS_AMOUNT = 5;
    private State myState = new State();

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(State state2) {
        this.myState = state2;
    }

    public boolean isShowDetails() {
        return this.myState.SHOW_DETAILS;
    }

    public void setShowDetails(boolean showDetails) {
        this.myState.SHOW_DETAILS = showDetails;
    }

    public void addRecentlyFilteredUserGroup(@NotNull List<String> usersInGroup) {
        if (usersInGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usersInGroup", "com/intellij/vcs/log/data/VcsLogUiProperties", "addRecentlyFilteredUserGroup"));
        }
        VcsLogUiProperties.addRecentGroup(usersInGroup, this.myState.RECENTLY_FILTERED_USER_GROUPS);
    }

    public void addRecentlyFilteredBranchGroup(@NotNull List<String> usersInGroup) {
        if (usersInGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usersInGroup", "com/intellij/vcs/log/data/VcsLogUiProperties", "addRecentlyFilteredBranchGroup"));
        }
        VcsLogUiProperties.addRecentGroup(usersInGroup, this.myState.RECENTLY_FILTERED_BRANCH_GROUPS);
    }

    private static void addRecentGroup(@NotNull List<String> usersInGroup, @NotNull Deque<UserGroup> stateField) {
        if (usersInGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usersInGroup", "com/intellij/vcs/log/data/VcsLogUiProperties", "addRecentGroup"));
        }
        if (stateField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateField", "com/intellij/vcs/log/data/VcsLogUiProperties", "addRecentGroup"));
        }
        UserGroup group = new UserGroup();
        group.users = usersInGroup;
        if (stateField.contains(group)) {
            return;
        }
        stateField.addFirst(group);
        if (stateField.size() > 5) {
            stateField.removeLast();
        }
    }

    @NotNull
    public List<List<String>> getRecentlyFilteredUserGroups() {
        List<List<String>> list = VcsLogUiProperties.getRecentGroup(this.myState.RECENTLY_FILTERED_USER_GROUPS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogUiProperties", "getRecentlyFilteredUserGroups"));
        }
        return list;
    }

    @NotNull
    public List<List<String>> getRecentlyFilteredBranchGroups() {
        List<List<String>> list = VcsLogUiProperties.getRecentGroup(this.myState.RECENTLY_FILTERED_BRANCH_GROUPS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogUiProperties", "getRecentlyFilteredBranchGroups"));
        }
        return list;
    }

    @NotNull
    private static List<List<String>> getRecentGroup(Deque<UserGroup> stateField) {
        List list = ContainerUtil.map2List(stateField, (Function)new Function<UserGroup, List<String>>(){

            public List<String> fun(UserGroup group) {
                return group.users;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogUiProperties", "getRecentGroup"));
        }
        return list;
    }

    public boolean areLongEdgesVisible() {
        return this.myState.LONG_EDGES_VISIBLE;
    }

    public void setLongEdgesVisibility(boolean visible) {
        this.myState.LONG_EDGES_VISIBLE = visible;
    }

    public boolean isBek() {
        return this.myState.BEK_SORT;
    }

    public void setBek(boolean isBek) {
        this.myState.BEK_SORT = isBek;
    }

    public static class UserGroup {
        public List<String> users = new ArrayList<String>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserGroup group = (UserGroup)o;
            return ((Object)this.users).equals(group.users);
        }

        public int hashCode() {
            return ((Object)this.users).hashCode();
        }
    }

    public static class State {
        public boolean SHOW_DETAILS = true;
        public boolean LONG_EDGES_VISIBLE = false;
        public boolean BEK_SORT = false;
        public Deque<UserGroup> RECENTLY_FILTERED_USER_GROUPS = new ArrayDeque<UserGroup>();
        public Deque<UserGroup> RECENTLY_FILTERED_BRANCH_GROUPS = new ArrayDeque<UserGroup>();
    }
}

