/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogMultiRepoJoiner<CommitId, Commit extends GraphCommit<CommitId>> {
    @NotNull
    public List<Commit> join(@NotNull Collection<List<Commit>> logsFromRepos) {
        if (logsFromRepos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logsFromRepos", "com/intellij/vcs/log/data/VcsLogMultiRepoJoiner", "join"));
        }
        if (logsFromRepos.size() == 1) {
            List<Commit> list = logsFromRepos.iterator().next();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogMultiRepoJoiner", "join"));
            }
            return list;
        }
        int size = 0;
        for (List<Commit> repo : logsFromRepos) {
            size += repo.size();
        }
        ArrayList result = new ArrayList(size);
        HashMap nextCommits = ContainerUtil.newHashMap();
        for (List<Commit> log : logsFromRepos) {
            Iterator<Commit> iterator = log.iterator();
            if (!iterator.hasNext()) continue;
            nextCommits.put(iterator.next(), iterator);
        }
        while (!nextCommits.isEmpty()) {
            Object lastCommit = this.findLatestCommit(nextCommits.keySet());
            Iterator iterator = (Iterator)nextCommits.get(lastCommit);
            result.add(lastCommit);
            nextCommits.remove(lastCommit);
            if (!iterator.hasNext()) continue;
            nextCommits.put(iterator.next(), iterator);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogMultiRepoJoiner", "join"));
        }
        return arrayList;
    }

    @NotNull
    private Commit findLatestCommit(@NotNull Set<Commit> commits) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/VcsLogMultiRepoJoiner", "findLatestCommit"));
        }
        long maxTimeStamp = Long.MIN_VALUE;
        GraphCommit lastCommit = null;
        for (GraphCommit commit : commits) {
            if (commit.getTimestamp() < maxTimeStamp) continue;
            maxTimeStamp = commit.getTimestamp();
            lastCommit = commit;
        }
        assert (lastCommit != null);
        GraphCommit graphCommit = lastCommit;
        if (graphCommit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogMultiRepoJoiner", "findLatestCommit"));
        }
        return (Commit)graphCommit;
    }
}

