/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.util.NotNullFunction;
import com.intellij.util.SofterReference;
import com.intellij.util.containers.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SofterCache<T, V> {
    private final NotNullFunction<T, V> myValueProvider;
    private SofterReference<ConcurrentMap<T, V>> myCache;

    public SofterCache(NotNullFunction<T, V> valueProvider) {
        this.myValueProvider = valueProvider;
    }

    public static <T, V> SofterCache<T, V> create(NotNullFunction<T, V> valueProvider) {
        return new SofterCache<T, V>(valueProvider);
    }

    public void clearCache() {
        this.myCache = null;
    }

    public V getCachedValue(T key) {
        Object value;
        ConcurrentHashMap map;
        SofterReference<ConcurrentMap<T, V>> ref = this.myCache;
        ConcurrentHashMap concurrentHashMap = map = ref == null ? null : ref.get();
        if (map == null) {
            map = new ConcurrentHashMap();
            this.myCache = new SofterReference<ConcurrentHashMap>(map);
        }
        if ((value = map.get(key)) == null) {
            value = this.myValueProvider.fun(key);
            map.put(key, value);
        }
        return value;
    }
}

