/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.javaee.web.PsiReferenceConverter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceFactory;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomReferenceInjector;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.ConverterManagerImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.GenericDomValueReference;
import com.intellij.xml.util.XmlEnumeratedValueReferenceProvider;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericValueReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.GenericValueReferenceProvider");
    private final Map<Class, PsiReferenceFactory> myProviders = new HashMap<Class, PsiReferenceFactory>();

    public void addReferenceProviderForClass(Class clazz, PsiReferenceFactory provider) {
        this.myProviders.put(clazz, provider);
    }

    @NotNull
    public final PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext context) {
        Object converter;
        GenericDomValue domValue;
        Referencing referencing;
        DomElement domElement;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
        }
        DomManager domManager = DomManager.getDomManager((Project)psiElement.getProject());
        if (psiElement instanceof XmlTag) {
            domElement = domManager.getDomElement((XmlTag)psiElement);
        } else if (psiElement instanceof XmlAttributeValue && psiElement.getParent() instanceof XmlAttribute) {
            domElement = domManager.getDomElement((XmlAttribute)psiElement.getParent());
        } else {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (!(domElement instanceof GenericDomValue)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (psiElement instanceof XmlTag) {
            for (XmlText text : ((XmlTag)psiElement).getValue().getTextElements()) {
                if (!InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)text)) continue;
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        } else if (InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)psiElement)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if ((referencing = (Referencing)(domValue = (GenericDomValue)domElement).getAnnotation(Referencing.class)) == null) {
            converter = WrappingConverter.getDeepestConverter((Converter)domValue.getConverter(), (GenericDomValue)domValue);
        } else {
            Class clazz = referencing.value();
            converter = ((ConverterManagerImpl)domManager.getConverterManager()).getInstance(clazz);
        }
        PsiReference[] references = this.createReferences(domValue, (XmlElement)psiElement, converter);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (PsiReference reference : references) {
                if (reference.isSoft()) continue;
                LOG.error("dom reference should be soft: " + reference + " (created by " + converter + ")");
            }
        }
        if (references.length > 0) {
            if (converter instanceof EnumConverter && !((EnumConverter)((Object)converter)).isExhaustive()) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            context.put(XmlEnumeratedValueReferenceProvider.SUPPRESS, (Object)Boolean.TRUE);
        }
        if (references == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
        }
        return references;
    }

    private static ConvertContext createConvertContext(PsiElement psiElement, GenericDomValue domValue) {
        return ConvertContextFactory.createConvertContext((DomElement)domValue);
    }

    @Nullable
    private static DomInvocationHandler getInvocationHandler(GenericDomValue domValue) {
        return DomManagerImpl.getDomInvocationHandler((DomElement)domValue);
    }

    private PsiReference[] createReferences(GenericDomValue domValue, XmlElement psiElement, Object converter) {
        ConvertContext context = GenericValueReferenceProvider.createConvertContext((PsiElement)psiElement, domValue);
        ArrayList result = new ArrayList();
        String unresolvedText = ElementManipulators.getValueText((PsiElement)psiElement);
        for (DomReferenceInjector each : DomUtil.getFileElement((DomElement)domValue).getFileDescription().getReferenceInjectors()) {
            Collections.addAll(result, each.inject(unresolvedText, (PsiElement)psiElement, context));
        }
        Collections.addAll(result, this.doCreateReferences(domValue, psiElement, converter, context));
        return result.toArray(new PsiReference[result.size()]);
    }

    @NotNull
    private PsiReference[] doCreateReferences(GenericDomValue domValue, XmlElement psiElement, Object converter, ConvertContext context) {
        if (converter instanceof CustomReferenceConverter) {
            PsiReference[] references = ((CustomReferenceConverter)converter).createReferences(domValue, (PsiElement)psiElement, context);
            if (references.length == 0 && converter instanceof ResolvingConverter) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new GenericDomValueReference(domValue)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "doCreateReferences"));
                }
                return psiReferenceArray;
            }
            if (references == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "doCreateReferences"));
            }
            return references;
        }
        if (converter instanceof PsiReferenceConverter) {
            PsiReference[] psiReferenceArray = ((PsiReferenceConverter)converter).createReferences((PsiElement)psiElement, true);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "doCreateReferences"));
            }
            return psiReferenceArray;
        }
        if (converter instanceof ResolvingConverter) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new GenericDomValueReference(domValue)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "doCreateReferences"));
            }
            return psiReferenceArray;
        }
        DomInvocationHandler invocationHandler = GenericValueReferenceProvider.getInvocationHandler(domValue);
        assert (invocationHandler != null);
        Class clazz = DomUtil.getGenericValueParameter((Type)invocationHandler.getDomElementType());
        if (clazz == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "doCreateReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (ReflectionUtil.isAssignable(Integer.class, (Class)clazz)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new GenericDomValueReference<Integer>(domValue){

                @Override
                @NotNull
                public Object[] getVariants() {
                    Object[] objectArray = new Object[]{"0"};
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider$1", "getVariants"));
                    }
                    return objectArray;
                }
            }};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "doCreateReferences"));
            }
            return psiReferenceArray;
        }
        if (ReflectionUtil.isAssignable(String.class, (Class)clazz)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "doCreateReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReferenceFactory provider = this.myProviders.get(clazz);
        if (provider != null) {
            PsiReference[] psiReferenceArray = provider.getReferencesByElement((PsiElement)psiElement);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "doCreateReferences"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "doCreateReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

