/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileByteBuffer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.FileByteBuffer");
    private final RandomAccessFile myFile;

    public FileByteBuffer(RandomAccessFile file) {
        this.myFile = file;
    }

    public byte get() {
        try {
            return this.myFile.readByte();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return 0;
        }
    }

    public FileByteBuffer put(byte b) {
        try {
            this.myFile.write(b);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    public byte get(int index) {
        try {
            this.myFile.seek(index);
            return this.myFile.readByte();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return 0;
        }
    }

    public FileByteBuffer put(int index, byte b) {
        try {
            this.myFile.seek(index);
            this.myFile.write(b);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    public char getChar() {
        try {
            return this.myFile.readChar();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return '\u0000';
        }
    }

    public FileByteBuffer putChar(char value) {
        try {
            this.myFile.writeChar(value);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    public char getChar(int index) {
        try {
            this.myFile.seek(index);
            return this.myFile.readChar();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return '\u0000';
        }
    }

    public FileByteBuffer putChar(int index, char value) {
        try {
            this.myFile.seek(index);
            this.myFile.writeChar(value);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    public short getShort() {
        try {
            return this.myFile.readShort();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return 0;
        }
    }

    public FileByteBuffer putShort(short value) {
        try {
            this.myFile.writeShort(value);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    public short getShort(int index) {
        try {
            this.myFile.seek(index);
            return this.myFile.readShort();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return 0;
        }
    }

    public FileByteBuffer putShort(int index, short value) {
        try {
            this.myFile.seek(index);
            this.myFile.writeShort(value);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    public int getInt() {
        try {
            return this.myFile.readInt();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return 0;
        }
    }

    public FileByteBuffer putInt(int value) {
        try {
            this.myFile.writeInt(value);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    public int getInt(int index) {
        try {
            this.myFile.seek(index);
            return this.myFile.readInt();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return 0;
        }
    }

    public FileByteBuffer putInt(int index, int value) {
        try {
            this.myFile.seek(index);
            this.myFile.writeInt(value);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    public long getLong() {
        try {
            return this.myFile.readLong();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return 0L;
        }
    }

    public FileByteBuffer putLong(long value) {
        try {
            this.myFile.writeLong(value);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    public long getLong(int index) {
        try {
            this.myFile.seek(index);
            return this.myFile.readLong();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return 0L;
        }
    }

    public FileByteBuffer putLong(int index, long value) {
        try {
            this.myFile.seek(index);
            this.myFile.writeLong(value);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    public void position(int index) {
        try {
            this.myFile.seek(index);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void put(byte[] src, int offset, int length) {
        try {
            this.myFile.write(src, offset, length);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public FileByteBuffer get(byte[] dst, int offset, int length) {
        try {
            this.myFile.read(dst, offset, length);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }
}

