/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.continuation;

import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.continuation.GeneralRunner;
import com.intellij.util.continuation.SameProgressRunner;
import com.intellij.util.continuation.SeparatePiecesRunner;
import com.intellij.util.continuation.TaskDescriptor;
import java.util.List;

public class Continuation {
    private GeneralRunner myGeneralRunner;

    private Continuation(GeneralRunner generalRunner) {
        this.myGeneralRunner = generalRunner;
    }

    public static Continuation createForCurrentProgress(Project project, boolean cancellable, String commonTitle) {
        return new Continuation(new SameProgressRunner(project, cancellable, commonTitle));
    }

    public static Continuation createFragmented(Project project, boolean cancellable) {
        SeparatePiecesRunner generalRunner = new SeparatePiecesRunner(project, cancellable);
        return new Continuation(generalRunner);
    }

    public void run(TaskDescriptor ... tasks) {
        if (tasks.length == 0) {
            return;
        }
        this.myGeneralRunner.next(tasks);
        this.myGeneralRunner.ping();
    }

    public void run(List<TaskDescriptor> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        this.myGeneralRunner.next(tasks);
        this.myGeneralRunner.ping();
    }

    public <T extends Exception> void addExceptionHandler(Class<T> clazz, Consumer<T> consumer) {
        this.myGeneralRunner.addExceptionHandler(clazz, consumer);
    }

    public void resume() {
        this.myGeneralRunner.ping();
    }

    public void resumeOnNewIndicator(Project project, boolean cancellable, String commonTitle) {
        SameProgressRunner runner = new SameProgressRunner(project, cancellable, commonTitle);
        runner.next((List)this.myGeneralRunner.myQueue);
        this.myGeneralRunner = runner;
        this.resume();
    }

    public void clearQueue() {
        this.myGeneralRunner.cancelEverything();
    }

    public void cancelCurrent() {
        this.myGeneralRunner.cancelCurrent();
    }

    public void add(List<TaskDescriptor> list) {
        this.myGeneralRunner.next(list);
    }

    public boolean isEmpty() {
        return this.myGeneralRunner.isEmpty();
    }

    public void onCancel() {
        this.myGeneralRunner.onCancel();
    }
}

