/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Consumer;
import com.intellij.util.LocalTimeCounter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldCompletionProvider {
    static final Key<TextFieldCompletionProvider> COMPLETING_TEXT_FIELD_KEY = Key.create((String)"COMPLETING_TEXT_FIELD_KEY");
    protected boolean myCaseInsensitivity;

    protected TextFieldCompletionProvider() {
        this(false);
    }

    protected TextFieldCompletionProvider(boolean caseInsensitivity) {
        this.myCaseInsensitivity = caseInsensitivity;
    }

    public void apply(@NotNull EditorTextField field, @NotNull String text) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/util/TextFieldCompletionProvider", "apply"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/TextFieldCompletionProvider", "apply"));
        }
        Project project = field.getProject();
        if (project != null) {
            field.setDocument(this.createDocument(project, text));
        }
    }

    public void apply(@NotNull EditorTextField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/util/TextFieldCompletionProvider", "apply"));
        }
        this.apply(field, "");
    }

    private Document createDocument(Project project, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/TextFieldCompletionProvider", "createDocument"));
        }
        LanguageFileType fileType = PlainTextLanguage.INSTANCE.getAssociatedFileType();
        assert (fileType != null);
        long stamp = LocalTimeCounter.currentTime();
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("Dummy." + fileType.getDefaultExtension(), (FileType)fileType, (CharSequence)text, stamp, true, false);
        psiFile.putUserData(COMPLETING_TEXT_FIELD_KEY, (Object)this);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        assert (document != null);
        return document;
    }

    public boolean isCaseInsensitivity() {
        return this.myCaseInsensitivity;
    }

    @NotNull
    protected String getPrefix(@NotNull String currentTextPrefix) {
        if (currentTextPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentTextPrefix", "com/intellij/util/TextFieldCompletionProvider", "getPrefix"));
        }
        String string = currentTextPrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/TextFieldCompletionProvider", "getPrefix"));
        }
        return string;
    }

    protected abstract void addCompletionVariants(@NotNull String var1, int var2, @NotNull String var3, @NotNull CompletionResultSet var4);

    @NotNull
    public EditorTextField createEditor(Project project) {
        EditorTextField editorTextField = this.createEditor(project, true);
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/TextFieldCompletionProvider", "createEditor"));
        }
        return editorTextField;
    }

    @NotNull
    public EditorTextField createEditor(Project project, boolean shouldHaveBorder) {
        EditorTextField editorTextField = this.createEditor(project, shouldHaveBorder, null);
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/TextFieldCompletionProvider", "createEditor"));
        }
        return editorTextField;
    }

    @NotNull
    public EditorTextField createEditor(Project project, final boolean shouldHaveBorder, final @Nullable Consumer<Editor> editorConstructionCallback) {
        EditorTextField editorTextField = new EditorTextField(this.createDocument(project, ""), project, (FileType)PlainTextLanguage.INSTANCE.getAssociatedFileType()){

            @Override
            protected boolean shouldHaveBorder() {
                return shouldHaveBorder;
            }

            @Override
            protected void updateBorder(@NotNull EditorEx editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/util/TextFieldCompletionProvider$1", "updateBorder"));
                }
                if (shouldHaveBorder) {
                    super.updateBorder(editor);
                } else {
                    editor.setBorder(null);
                }
            }

            @Override
            protected EditorEx createEditor() {
                EditorEx result = super.createEditor();
                if (editorConstructionCallback != null) {
                    editorConstructionCallback.consume((Object)result);
                }
                return result;
            }
        };
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/TextFieldCompletionProvider", "createEditor"));
        }
        return editorTextField;
    }
}

