/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.util.TextFieldCompletionProvider;
import org.jetbrains.annotations.NotNull;

public class CompletionContributorForTextField
extends CompletionContributor
implements DumbAware {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/CompletionContributorForTextField", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/CompletionContributorForTextField", "fillCompletionVariants"));
        }
        PsiFile file = parameters.getOriginalFile();
        if (!(file instanceof PsiPlainTextFile)) {
            return;
        }
        TextFieldCompletionProvider field = (TextFieldCompletionProvider)file.getUserData(TextFieldCompletionProvider.COMPLETING_TEXT_FIELD_KEY);
        if (field == null) {
            return;
        }
        if (!(field instanceof DumbAware) && DumbService.isDumb((Project)file.getProject())) {
            return;
        }
        String text = file.getText();
        int offset = Math.min(text.length(), parameters.getOffset());
        String prefix = field.getPrefix(text.substring(0, offset));
        CompletionResultSet activeResult = !result.getPrefixMatcher().getPrefix().equals(prefix) ? result.withPrefixMatcher(prefix) : result;
        if (field.isCaseInsensitivity()) {
            activeResult = activeResult.caseInsensitive();
        }
        field.addCompletionVariants(text, offset, prefix, activeResult);
    }
}

