/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.util.concurrent.atomic.AtomicInteger;

public class JDK7WindowReorderingWorkaround {
    private static AtomicInteger requestorCount = new AtomicInteger();
    private static final Callback windowDidBecomeMainCallback = new Callback(){

        public void callback(ID self, ID nsNotification) {
            if (requestorCount.intValue() == 0) {
                Foundation.invoke((ID)self, (String)"oldWindowDidBecomeMain:", (Object[])new Object[]{nsNotification});
            }
        }
    };

    static void disableReordering() {
        if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
            requestorCount.incrementAndGet();
        }
    }

    static void enableReordering() {
        if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
            requestorCount.decrementAndGet();
        }
    }

    static {
        if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
            ID awtWindow = Foundation.getObjcClass((String)"AWTWindow");
            Pointer windowWillEnterFullScreenMethod = Foundation.createSelector((String)"windowDidBecomeMain:");
            ID originalWindowWillEnterFullScreen = Foundation.class_replaceMethod((ID)awtWindow, (Pointer)windowWillEnterFullScreenMethod, (Callback)windowDidBecomeMainCallback, (String)"v@::@");
            Foundation.addMethodByID((ID)awtWindow, (Pointer)Foundation.createSelector((String)"oldWindowDidBecomeMain:"), (ID)originalWindowWillEnterFullScreen, (String)"v@::@");
        }
    }
}

