/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.ui.Splash;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ShowSplashAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        ApplicationInfoEx app = ApplicationInfoImpl.getShadowInstance();
        Splash splash = new Splash(app.getSplashImageUrl(), app.getSplashTextColor());
        SplashListener listener = new SplashListener(splash);
        splash.addFocusListener(listener);
        splash.addKeyListener(listener);
        splash.addMouseListener(listener);
        splash.show();
    }

    private static class SplashListener
    implements KeyListener,
    MouseListener,
    FocusListener {
        private final Splash mySplash;

        private SplashListener(Splash splash) {
            this.mySplash = splash;
        }

        private void close() {
            if (this.mySplash.isVisible()) {
                this.mySplash.setVisible(false);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.close();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.close();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.close();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.close();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.close();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.close();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.close();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

