/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.Function;
import com.intellij.util.containers.Convertor;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;

public class ListSpeedSearch
extends SpeedSearchBase<JList> {
    private final Convertor<Object, String> myToStringConvertor;

    public ListSpeedSearch(JList list) {
        super(list);
        this.myToStringConvertor = null;
    }

    public ListSpeedSearch(JList component, Convertor<Object, String> convertor) {
        super(component);
        this.myToStringConvertor = convertor;
    }

    public ListSpeedSearch(JList component, final Function<Object, String> convertor) {
        this(component, new Convertor<Object, String>(){

            public String convert(Object o) {
                return (String)convertor.fun(o);
            }
        });
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        ListScrollingUtil.selectItem((JList)((JList)this.myComponent), (Object)element);
    }

    @Override
    protected int getSelectedIndex() {
        return ((JList)this.myComponent).getSelectedIndex();
    }

    @Override
    protected Object[] getAllElements() {
        return ListSpeedSearch.getAllListElements((JList)this.myComponent);
    }

    public static Object[] getAllListElements(JList list) {
        ListModel model = list.getModel();
        if (model instanceof DefaultListModel) {
            return ((DefaultListModel)model).toArray();
        }
        Object[] elements = new Object[model.getSize()];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = model.getElementAt(i);
        }
        return elements;
    }

    @Override
    protected String getElementText(Object element) {
        if (this.myToStringConvertor != null) {
            return (String)this.myToStringConvertor.convert(element);
        }
        return element == null ? null : element.toString();
    }
}

