/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.actions.RenameElementAction;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.spellchecker.quickfixes.DictionarySuggestionProvider;
import com.intellij.spellchecker.quickfixes.ShowSuggestions;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.containers.HashMap;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameTo
extends ShowSuggestions
implements SpellCheckerQuickFix {
    public RenameTo(String wordWithTypo) {
        super(wordWithTypo);
    }

    @NotNull
    public String getName() {
        String string = SpellCheckerBundle.message("rename.to", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/quickfixes/RenameTo", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpellCheckerBundle.message("rename.to", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/quickfixes/RenameTo", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    private static DictionarySuggestionProvider findProvider() {
        Object[] extensions;
        for (Object extension : extensions = Extensions.getExtensions((ExtensionPointName)NameSuggestionProvider.EP_NAME)) {
            if (!(extension instanceof DictionarySuggestionProvider)) continue;
            return (DictionarySuggestionProvider)((Object)extension);
        }
        return null;
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        Anchor anchor = Anchor.FIRST;
        if (anchor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/quickfixes/RenameTo", "getPopupActionAnchor"));
        }
        return anchor;
    }

    public void applyFix(final @NotNull Project project, final @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spellchecker/quickfixes/RenameTo", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spellchecker/quickfixes/RenameTo", "applyFix"));
        }
        Runnable fix = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DictionarySuggestionProvider provider = RenameTo.findProvider();
                if (provider != null) {
                    provider.setActive(true);
                }
                Editor editor = RenameTo.getEditorFromFocus();
                HashMap map = new HashMap();
                PsiElement psiElement = descriptor.getPsiElement();
                if (psiElement == null) {
                    return;
                }
                PsiFile containingFile = psiElement.getContainingFile();
                if (editor == null) {
                    editor = InjectedLanguageUtil.openEditorFor(containingFile, project);
                }
                if (editor == null) {
                    return;
                }
                if (editor instanceof EditorWindow) {
                    map.put((Object)CommonDataKeys.EDITOR.getName(), (Object)editor);
                    map.put((Object)CommonDataKeys.PSI_ELEMENT.getName(), (Object)psiElement);
                } else if (ApplicationManager.getApplication().isUnitTestMode()) {
                    map.put((Object)CommonDataKeys.PSI_ELEMENT.getName(), new TextEditorPsiDataProvider().getData(CommonDataKeys.PSI_ELEMENT.getName(), editor, editor.getCaretModel().getCurrentCaret()));
                }
                Boolean selectAll = (Boolean)editor.getUserData(RenameHandlerRegistry.SELECT_ALL);
                try {
                    editor.putUserData(RenameHandlerRegistry.SELECT_ALL, (Object)true);
                    DataContext dataContext = SimpleDataContext.getSimpleContext((Map<String, Object>)map, DataManager.getInstance().getDataContext((Component)editor.getComponent()));
                    RenameElementAction action = new RenameElementAction();
                    AnActionEvent event = new AnActionEvent(null, dataContext, "", action.getTemplatePresentation(), ActionManager.getInstance(), 0);
                    action.actionPerformed(event);
                    if (provider != null) {
                        provider.setActive(false);
                    }
                }
                finally {
                    editor.putUserData(RenameHandlerRegistry.SELECT_ALL, (Object)selectAll);
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            fix.run();
        } else {
            SwingUtilities.invokeLater(fix);
        }
    }

    @Nullable
    private static Editor getEditorFromFocus() {
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c instanceof EditorComponentImpl) {
            return ((EditorComponentImpl)c).getEditor();
        }
        return null;
    }
}

