/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.util.Consumer;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jetbrains.annotations.NotNull;

public class StreamLoader
implements Loader {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.StreamLoader");
    private final InputStream stream;
    private final String name;

    public StreamLoader(InputStream stream, String name) {
        this.stream = stream;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spellchecker/StreamLoader", "load"));
        }
        DataInputStream in = new DataInputStream(this.stream);
        BufferedReader br = null;
        try {
            String strLine;
            br = new BufferedReader(new InputStreamReader((InputStream)in, CharsetToolkit.UTF8_CHARSET));
            while ((strLine = br.readLine()) != null) {
                consumer.consume((Object)strLine);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ignored) {}
        }
    }
}

