/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerImpl;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServerNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.impl.runtime.ui.tree.TreeBuilderBase;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionListener;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ServersToolWindowContent
extends JPanel
implements Disposable {
    public static final DataKey<ServersToolWindowContent> KEY = DataKey.create((String)"serversToolWindowContent");
    @NonNls
    private static final String PLACE_TOOLBAR = "ServersToolWindowContent#Toolbar";
    @NonNls
    private static final String SERVERS_TOOL_WINDOW_TOOLBAR = "RemoteServersViewToolbar";
    @NonNls
    private static final String HELP_ID = "Application_Servers_tool_window";
    private static final String MESSAGE_CARD = "message";
    private static final String EMPTY_SELECTION_MESSAGE = "Select a server or deployment in the tree to view details";
    private static final int POLL_DEPLOYMENTS_DELAY = 2000;
    private final Tree myTree;
    private final CardLayout myPropertiesPanelLayout;
    private final JPanel myPropertiesPanel;
    private final JLabel myMessageLabel;
    private final Map<String, JComponent> myLogComponents;
    private final DefaultTreeModel myTreeModel;
    private TreeBuilderBase myBuilder;
    private AbstractTreeNode<?> myLastSelection;
    private final Project myProject;

    public ServersToolWindowContent(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent", "<init>"));
        }
        super(new BorderLayout());
        this.myLogComponents = new HashMap<String, JComponent>();
        this.myProject = project;
        this.myTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.myTree.setLineStyleAngled();
        this.getMainPanel().add((Component)this.createToolbar(), "West");
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)1));
        this.myPropertiesPanelLayout = new CardLayout();
        this.myPropertiesPanel = new JPanel(this.myPropertiesPanelLayout);
        this.myMessageLabel = new JLabel(EMPTY_SELECTION_MESSAGE, 0);
        this.myPropertiesPanel.add(MESSAGE_CARD, (Component)new Wrapper((JComponent)this.myMessageLabel));
        splitter.setSecondComponent((JComponent)this.myPropertiesPanel);
        this.getMainPanel().add((Component)splitter, "Center");
        this.setupBuilder(project);
        for (RemoteServersViewContributor contributor : (RemoteServersViewContributor[])RemoteServersViewContributor.EP_NAME.getExtensions()) {
            contributor.setupTree(this.myProject, this.myTree, this.myBuilder);
        }
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ServersToolWindowContent.this.onSelectionChanged();
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                Set<ServersTreeStructure.RemoteServerNode> nodes = ServersToolWindowContent.this.getSelectedRemoteServerNodes();
                if (nodes.size() == 1) {
                    RemoteServer server = (RemoteServer)nodes.iterator().next().getValue();
                    ServerConnectionManager.getInstance().getOrCreateConnection(server);
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myTree);
    }

    private void onSelectionChanged() {
        Set nodes = this.myBuilder.getSelectedElements(AbstractTreeNode.class);
        if (nodes.size() != 1) {
            this.showMessageLabel(EMPTY_SELECTION_MESSAGE);
            this.myLastSelection = null;
            return;
        }
        AbstractTreeNode node = (AbstractTreeNode)nodes.iterator().next();
        if (Comparing.equal((Object)node, this.myLastSelection)) {
            return;
        }
        this.myLastSelection = node;
        if (node instanceof ServersTreeStructure.LogProvidingNode) {
            ServersTreeStructure.LogProvidingNode logNode = (ServersTreeStructure.LogProvidingNode)node;
            LoggingHandlerImpl loggingHandler = logNode.getLoggingHandler();
            if (loggingHandler != null) {
                String cardName = logNode.getLogId();
                JComponent oldComponent = this.myLogComponents.get(cardName);
                JComponent logComponent = loggingHandler.getConsole().getComponent();
                if (!logComponent.equals(oldComponent)) {
                    this.myLogComponents.put(cardName, logComponent);
                    if (oldComponent != null) {
                        this.myPropertiesPanel.remove(oldComponent);
                    }
                    this.myPropertiesPanel.add(cardName, logComponent);
                }
                this.myPropertiesPanelLayout.show(this.myPropertiesPanel, cardName);
            } else {
                this.showMessageLabel("");
            }
        } else if (node instanceof ServersTreeStructure.RemoteServerNode) {
            this.updateServerDetails((ServersTreeStructure.RemoteServerNode)node);
        } else {
            this.showMessageLabel("");
        }
    }

    private void updateServerDetails(ServersTreeStructure.RemoteServerNode node) {
        RemoteServer server = (RemoteServer)node.getValue();
        ServerConnection connection = ServerConnectionManager.getInstance().getConnection(server);
        if (connection == null || connection.getStatus() == ConnectionStatus.DISCONNECTED) {
            this.showMessageLabel("Double-click on the server node to connect");
        } else {
            this.showMessageLabel(connection.getStatusText());
        }
    }

    private void showMessageLabel(String text) {
        this.myMessageLabel.setText(UIUtil.toHtml((String)text));
        this.myPropertiesPanelLayout.show(this.myPropertiesPanel, MESSAGE_CARD);
    }

    private void setupBuilder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent", "setupBuilder"));
        }
        ServersTreeStructure structure = new ServersTreeStructure(project);
        this.myBuilder = new TreeBuilderBase((JTree)this.myTree, structure, this.myTreeModel){

            protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
                return nodeDescriptor instanceof ServersTreeStructure.RemoteServerNode || nodeDescriptor instanceof ServersTreeStructure.DeploymentNodeImpl;
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        project.getMessageBus().connect().subscribe(ServerConnectionListener.TOPIC, (Object)new ServerConnectionListener(){

            public void onConnectionCreated(@NotNull ServerConnection<?> connection) {
                if (connection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent$4", "onConnectionCreated"));
                }
                ServersToolWindowContent.this.getBuilder().queueUpdate();
                ServersToolWindowContent.pollDeployments(connection);
            }

            public void onConnectionStatusChanged(@NotNull ServerConnection<?> connection) {
                if (connection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent$4", "onConnectionStatusChanged"));
                }
                ServersToolWindowContent.this.getBuilder().queueUpdate();
                ServersToolWindowContent.this.updateSelectedServerDetails();
            }

            public void onDeploymentsChanged(@NotNull ServerConnection<?> connection) {
                if (connection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent$4", "onDeploymentsChanged"));
                }
                ServersToolWindowContent.this.getBuilder().queueUpdate();
                ServersToolWindowContent.this.updateSelectedServerDetails();
            }
        });
    }

    private void updateSelectedServerDetails() {
        if (this.myLastSelection instanceof ServersTreeStructure.RemoteServerNode) {
            this.updateServerDetails((ServersTreeStructure.RemoteServerNode)this.myLastSelection);
        }
    }

    private static void pollDeployments(final ServerConnection connection) {
        connection.computeDeployments(new Runnable(){

            @Override
            public void run() {
                new Alarm().addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (connection == ServerConnectionManager.getInstance().getConnection(connection.getServer())) {
                            ServersToolWindowContent.pollDeployments(connection);
                        }
                    }
                }, 2000, ModalityState.any());
            }
        });
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction(SERVERS_TOOL_WINDOW_TOOLBAR));
        group.add((AnAction)new Separator());
        group.add((AnAction)new ContextHelpAction(HELP_ID));
        ActionToolbar actionToolBar = ActionManager.getInstance().createActionToolbar(PLACE_TOOLBAR, (ActionGroup)group, false);
        this.myTree.putClientProperty((Object)"DataProvider", (Object)new DataProvider(){

            public Object getData(@NonNls String dataId) {
                if (KEY.getName().equals(dataId)) {
                    return ServersToolWindowContent.this;
                }
                for (RemoteServersViewContributor contributor : (RemoteServersViewContributor[])RemoteServersViewContributor.EP_NAME.getExtensions()) {
                    Object data = contributor.getData(dataId, ServersToolWindowContent.this);
                    if (data == null) continue;
                    return data;
                }
                return null;
            }
        });
        actionToolBar.setTargetComponent((JComponent)this.myTree);
        return actionToolBar.getComponent();
    }

    public JPanel getMainPanel() {
        return this;
    }

    public Set<ServerNode> getSelectedServerNodes() {
        return this.myBuilder.getSelectedElements(ServerNode.class);
    }

    public Set<DeploymentNode> getSelectedDeploymentNodes() {
        return this.myBuilder.getSelectedElements(DeploymentNode.class);
    }

    public Set<ServersTreeStructure.RemoteServerNode> getSelectedRemoteServerNodes() {
        return this.myBuilder.getSelectedElements(ServersTreeStructure.RemoteServerNode.class);
    }

    public void dispose() {
    }

    public TreeBuilderBase getBuilder() {
        return this.myBuilder;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent", "getProject"));
        }
        return project;
    }

    public void select(final @NotNull ServerConnection<?> connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent", "select"));
        }
        this.myBuilder.select(ServersTreeStructure.RemoteServerNode.class, (TreeVisitor)new TreeVisitor<ServersTreeStructure.RemoteServerNode>(){

            public boolean visit(@NotNull ServersTreeStructure.RemoteServerNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent$7", "visit"));
                }
                return ((RemoteServer)node.getValue()).equals(connection.getServer());
            }
        }, null, false);
    }

    public void select(final @NotNull ServerConnection<?> connection, final @NotNull String deploymentName) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent", "select"));
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentName", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent", "select"));
        }
        this.myBuilder.getUi().queueUpdate(connection).doWhenDone(new Runnable(){

            @Override
            public void run() {
                ServersToolWindowContent.this.myBuilder.select(ServersTreeStructure.DeploymentNodeImpl.class, (TreeVisitor)new TreeVisitor<ServersTreeStructure.DeploymentNodeImpl>(){

                    public boolean visit(@NotNull ServersTreeStructure.DeploymentNodeImpl node) {
                        if (node == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowContent$8$1", "visit"));
                        }
                        AbstractTreeNode parent = node.getParent();
                        return parent instanceof ServersTreeStructure.RemoteServerNode && ((RemoteServer)((ServersTreeStructure.RemoteServerNode)parent).getValue()).equals(connection.getServer()) && ((Deployment)node.getValue()).getName().equals(deploymentName);
                    }
                }, null, false);
            }
        });
    }
}

