/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerImpl;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class DeploymentLogManagerImpl
implements DeploymentLogManager {
    private final LoggingHandlerImpl myMainLoggingHandler;
    private final Project myProject;
    private final Map<String, LoggingHandlerImpl> myAdditionalLoggingHandlers;
    private final Runnable myChangeListener;
    private final AtomicBoolean myLogsDisposed;
    private final Disposable myLogsDisposable;

    public DeploymentLogManagerImpl(@NotNull Project project, @NotNull Runnable changeListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl", "<init>"));
        }
        if (changeListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListener", "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl", "<init>"));
        }
        this.myAdditionalLoggingHandlers = new HashMap<String, LoggingHandlerImpl>();
        this.myLogsDisposed = new AtomicBoolean(false);
        this.myProject = project;
        this.myChangeListener = changeListener;
        this.myMainLoggingHandler = new LoggingHandlerImpl(project);
        this.myLogsDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myLogsDisposable, (Disposable)this.myMainLoggingHandler);
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                DeploymentLogManagerImpl.this.disposeLogs();
            }
        });
    }

    @NotNull
    public LoggingHandlerImpl getMainLoggingHandler() {
        LoggingHandlerImpl loggingHandlerImpl = this.myMainLoggingHandler;
        if (loggingHandlerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl", "getMainLoggingHandler"));
        }
        return loggingHandlerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public LoggingHandler addAdditionalLog(@NotNull String presentableName) {
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl", "addAdditionalLog"));
        }
        LoggingHandlerImpl handler = new LoggingHandlerImpl(this.myProject);
        Disposer.register((Disposable)this.myLogsDisposable, (Disposable)handler);
        Map<String, LoggingHandlerImpl> map = this.myAdditionalLoggingHandlers;
        synchronized (map) {
            this.myAdditionalLoggingHandlers.put(presentableName, handler);
        }
        this.myChangeListener.run();
        LoggingHandlerImpl loggingHandlerImpl = handler;
        if (loggingHandlerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl", "addAdditionalLog"));
        }
        return loggingHandlerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, LoggingHandlerImpl> getAdditionalLoggingHandlers() {
        HashMap<String, LoggingHandlerImpl> result;
        Map<String, LoggingHandlerImpl> map = this.myAdditionalLoggingHandlers;
        synchronized (map) {
            result = new HashMap<String, LoggingHandlerImpl>(this.myAdditionalLoggingHandlers);
        }
        HashMap<String, LoggingHandlerImpl> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl", "getAdditionalLoggingHandlers"));
        }
        return hashMap;
    }

    public void disposeLogs() {
        if (!this.myLogsDisposed.getAndSet(true)) {
            Disposer.dispose((Disposable)this.myLogsDisposable);
        }
    }
}

