/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class ServerTaskExecutorImpl
implements ServerTaskExecutor {
    private static final Logger LOG = Logger.getInstance(ServerTaskExecutorImpl.class);
    private final SequentialTaskExecutor myTaskExecutor = new SequentialTaskExecutor((Executor)PooledThreadExecutor.INSTANCE);

    public void execute(@NotNull Runnable command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/remoteServer/impl/runtime/ServerTaskExecutorImpl", "execute"));
        }
        this.myTaskExecutor.execute(command);
    }

    public void submit(@NotNull Runnable command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/remoteServer/impl/runtime/ServerTaskExecutorImpl", "submit"));
        }
        this.execute(command);
    }

    public void submit(final @NotNull ThrowableRunnable<?> command, final @NotNull RemoteOperationCallback callback) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/remoteServer/impl/runtime/ServerTaskExecutorImpl", "submit"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/remoteServer/impl/runtime/ServerTaskExecutorImpl", "submit"));
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    command.run();
                }
                catch (Throwable e) {
                    LOG.info(e);
                    callback.errorOccurred(e.getMessage());
                }
            }
        });
    }
}

