/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl.util;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UrlCollector {
    private static final Logger LOG = Logger.getInstance((String)("#" + UrlCollector.class.getName()));
    private List<File> myFiles;

    public URL[] collect(Collection<File> libraries) {
        List<File> files = this.collectFiles(libraries);
        URL[] result = new URL[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            try {
                result[i] = files.get(i).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        return result;
    }

    public List<File> collectFiles(Collection<File> libraries) {
        this.myFiles = new ArrayList<File>();
        for (File library : libraries) {
            if (!library.exists()) continue;
            this.addFile(library);
            if (!library.isDirectory()) continue;
            this.addLibraries(library);
        }
        return this.myFiles;
    }

    private void addLibraries(File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.addLibraries(file);
                continue;
            }
            if (!file.getName().endsWith(".jar")) continue;
            this.addFile(file);
        }
    }

    private void addFile(File file) {
        LOG.debug("addFile: " + file.getAbsolutePath());
        this.myFiles.add(file);
    }
}

