/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.CommonBundle;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyFilesOrDirectoriesHandler
extends CopyHandlerDelegateBase {
    private static Logger LOG = Logger.getInstance((String)"com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler");

    @Override
    public boolean canCopy(PsiElement[] elements, boolean fromUpdate) {
        HashSet<String> names = new HashSet<String>();
        for (PsiElement element : elements) {
            if (!(element instanceof PsiFileSystemItem)) {
                return false;
            }
            if (!element.isValid()) {
                return false;
            }
            if (element instanceof PsiCompiledFile) {
                return false;
            }
            String name = ((PsiFileSystemItem)element).getName();
            if (names.contains(name)) {
                return false;
            }
            names.add(name);
        }
        PsiElement[] filteredElements = PsiTreeUtil.filterAncestors((PsiElement[])elements);
        return filteredElements.length == elements.length;
    }

    @Override
    public void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        Project project;
        if (defaultTargetDirectory == null) {
            defaultTargetDirectory = CopyFilesOrDirectoriesHandler.getCommonParentDirectory(elements);
        }
        Project project2 = project = defaultTargetDirectory != null ? defaultTargetDirectory.getProject() : elements[0].getProject();
        if (defaultTargetDirectory != null && (defaultTargetDirectory = CopyFilesOrDirectoriesHandler.resolveDirectory(defaultTargetDirectory)) == null) {
            return;
        }
        defaultTargetDirectory = CopyFilesOrDirectoriesHandler.tryNotNullizeDirectory(project, defaultTargetDirectory);
        CopyFilesOrDirectoriesHandler.copyAsFiles(elements, defaultTargetDirectory, project);
    }

    @Nullable
    private static PsiDirectory tryNotNullizeDirectory(@NotNull Project project, @Nullable PsiDirectory defaultTargetDirectory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "tryNotNullizeDirectory"));
        }
        if (defaultTargetDirectory == null) {
            VirtualFile root = (VirtualFile)ArrayUtil.getFirstElement((Object[])ProjectRootManager.getInstance((Project)project).getContentRoots());
            if (root == null) {
                root = project.getBaseDir();
            }
            if (root == null) {
                root = VfsUtil.getUserHomeDir();
            }
            PsiDirectory psiDirectory = defaultTargetDirectory = root != null ? PsiManager.getInstance((Project)project).findDirectory(root) : null;
            if (defaultTargetDirectory == null) {
                LOG.warn("No directory found for project: " + project.getName() + ", root: " + root);
            }
        }
        return defaultTargetDirectory;
    }

    public static void copyAsFiles(PsiElement[] elements, @Nullable PsiDirectory defaultTargetDirectory, Project project) {
        PsiDirectory targetDirectory = null;
        String newName = null;
        boolean openInEditor = true;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            targetDirectory = defaultTargetDirectory;
        } else {
            CopyFilesOrDirectoriesDialog dialog = new CopyFilesOrDirectoriesDialog(elements, defaultTargetDirectory, project, false);
            dialog.show();
            if (dialog.isOK()) {
                newName = elements.length == 1 ? dialog.getNewName() : null;
                targetDirectory = dialog.getTargetDirectory();
                openInEditor = dialog.openInEditor();
            }
        }
        if (targetDirectory != null) {
            try {
                for (PsiElement element : elements) {
                    PsiFileSystemItem psiElement = (PsiFileSystemItem)element;
                    if (!psiElement.isDirectory()) continue;
                    MoveFilesOrDirectoriesUtil.checkIfMoveIntoSelf((PsiElement)psiElement, (PsiElement)targetDirectory);
                }
            }
            catch (IncorrectOperationException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, null, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), null);
                return;
            }
            CopyFilesOrDirectoriesHandler.copyImpl(elements, newName, targetDirectory, false, openInEditor);
        }
    }

    @Override
    public void doClone(PsiElement element) {
        CopyFilesOrDirectoriesHandler.doCloneFile(element);
    }

    public static void doCloneFile(PsiElement element) {
        PsiDirectory targetDirectory = element instanceof PsiDirectory ? ((PsiDirectory)element).getParentDirectory() : PlatformPackageUtil.getDirectory(element);
        targetDirectory = CopyFilesOrDirectoriesHandler.tryNotNullizeDirectory(element.getProject(), targetDirectory);
        if (targetDirectory == null) {
            return;
        }
        PsiElement[] elements = new PsiElement[]{element};
        CopyFilesOrDirectoriesDialog dialog = new CopyFilesOrDirectoriesDialog(elements, null, element.getProject(), true);
        dialog.show();
        if (dialog.isOK()) {
            String newName = dialog.getNewName();
            CopyFilesOrDirectoriesHandler.copyImpl(elements, newName, targetDirectory, true, true);
        }
    }

    @Nullable
    private static PsiDirectory getCommonParentDirectory(PsiElement[] elements) {
        PsiDirectory result = null;
        for (PsiElement element : elements) {
            PsiDirectory directory;
            if (element instanceof PsiDirectory) {
                directory = (PsiDirectory)element;
                directory = directory.getParentDirectory();
            } else if (element instanceof PsiFile) {
                directory = PlatformPackageUtil.getDirectory(element);
            } else {
                throw new IllegalArgumentException("unexpected element " + element);
            }
            if (directory == null) continue;
            if (result == null) {
                result = directory;
                continue;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)directory, (PsiElement)result, (boolean)true)) continue;
            result = directory;
        }
        return result;
    }

    private static void copyImpl(final @NotNull PsiElement[] elements, final @Nullable String newName, final @NotNull PsiDirectory targetDirectory, final boolean doClone, final boolean openInEditor) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "copyImpl"));
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDirectory", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "copyImpl"));
        }
        if (doClone && elements.length != 1) {
            throw new IllegalArgumentException("invalid number of elements to clone:" + elements.length);
        }
        if (newName != null && elements.length != 1) {
            throw new IllegalArgumentException("no new name should be set; number of elements is: " + elements.length);
        }
        final Project project = targetDirectory.getProject();
        Runnable command = new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int[] nArray;
                            PsiFile firstFile = null;
                            if (elements.length > 1 || elements[0] instanceof PsiDirectory) {
                                int[] nArray2 = new int[1];
                                nArray = nArray2;
                                nArray2[0] = -1;
                            } else {
                                nArray = null;
                            }
                            int[] choice = nArray;
                            for (PsiElement element : elements) {
                                PsiFile f = CopyFilesOrDirectoriesHandler.copyToDirectory((PsiFileSystemItem)element, newName, targetDirectory, choice);
                                if (firstFile != null) continue;
                                firstFile = f;
                            }
                            if (firstFile != null) {
                                CopyHandler.updateSelectionInActiveProjectView(firstFile, project, doClone);
                                if (!(firstFile instanceof PsiBinaryFile) && openInEditor) {
                                    EditorHelper.openInEditor((PsiElement)firstFile);
                                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            ToolWindowManager.getInstance((Project)project).activateEditorComponent();
                                        }
                                    });
                                }
                            }
                        }
                        catch (IncorrectOperationException ex) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Messages.showErrorDialog((Project)project, (String)ex.getMessage(), (String)RefactoringBundle.message((String)"error.title"));
                                }
                            });
                        }
                        catch (IOException ex) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Messages.showErrorDialog((Project)project, (String)ex.getMessage(), (String)RefactoringBundle.message((String)"error.title"));
                                }
                            });
                        }
                    }
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }
        };
        String title = RefactoringBundle.message((String)(doClone ? "copy,handler.clone.files.directories" : "copy.handler.copy.files.directories"));
        CommandProcessor.getInstance().executeCommand(project, command, title, null);
    }

    @Nullable
    public static PsiFile copyToDirectory(@NotNull PsiFileSystemItem elementToCopy, @Nullable String newName, @NotNull PsiDirectory targetDirectory) throws IncorrectOperationException, IOException {
        if (elementToCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToCopy", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "copyToDirectory"));
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDirectory", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "copyToDirectory"));
        }
        return CopyFilesOrDirectoriesHandler.copyToDirectory(elementToCopy, newName, targetDirectory, null);
    }

    @Nullable
    public static PsiFile copyToDirectory(@NotNull PsiFileSystemItem elementToCopy, @Nullable String newName, @NotNull PsiDirectory targetDirectory, @Nullable int[] choice) throws IncorrectOperationException, IOException {
        if (elementToCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToCopy", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "copyToDirectory"));
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDirectory", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "copyToDirectory"));
        }
        if (elementToCopy instanceof PsiFile) {
            String name;
            PsiFile file = (PsiFile)elementToCopy;
            String string = name = newName == null ? file.getName() : newName;
            if (CopyFilesOrDirectoriesHandler.checkFileExist(targetDirectory, choice, file, name, "Copy")) {
                return null;
            }
            return targetDirectory.copyFileFrom(name, file);
        }
        if (elementToCopy instanceof PsiDirectory) {
            PsiElement[] children;
            PsiDirectory existing;
            PsiDirectory directory = (PsiDirectory)elementToCopy;
            if (directory.equals(targetDirectory)) {
                return null;
            }
            if (newName == null) {
                newName = directory.getName();
            }
            final PsiDirectory subdirectory = (existing = targetDirectory.findSubdirectory(newName)) == null ? targetDirectory.createSubdirectory(newName) : existing;
            EncodingRegistry.doActionAndRestoreEncoding((VirtualFile)directory.getVirtualFile(), (ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

                public VirtualFile compute() {
                    return subdirectory.getVirtualFile();
                }
            });
            PsiFile firstFile = null;
            for (PsiElement child : children = directory.getChildren()) {
                PsiFileSystemItem item = (PsiFileSystemItem)child;
                PsiFile f = CopyFilesOrDirectoriesHandler.copyToDirectory(item, item.getName(), subdirectory, choice);
                if (firstFile != null) continue;
                firstFile = f;
            }
            return firstFile;
        }
        throw new IllegalArgumentException("unexpected elementToCopy: " + elementToCopy);
    }

    public static boolean checkFileExist(@Nullable PsiDirectory targetDirectory, int[] choice, PsiFile file, String name, String title) {
        if (targetDirectory == null) {
            return false;
        }
        PsiFile existing = targetDirectory.findFile(name);
        if (existing != null && !existing.equals(file)) {
            int selection;
            if (choice == null || choice[0] == -1) {
                String[] stringArray;
                String message = String.format("File '%s' already exists in directory '%s'", name, targetDirectory.getVirtualFile().getPath());
                if (choice == null) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "Overwrite";
                    stringArray = stringArray2;
                    stringArray2[1] = "Skip";
                } else {
                    String[] stringArray3 = new String[4];
                    stringArray3[0] = "Overwrite";
                    stringArray3[1] = "Skip";
                    stringArray3[2] = "Overwrite for all";
                    stringArray = stringArray3;
                    stringArray3[3] = "Skip for all";
                }
                String[] options = stringArray;
                selection = Messages.showDialog((String)message, (String)title, (String[])options, (int)0, (Icon)Messages.getQuestionIcon());
            } else {
                selection = choice[0];
            }
            if (choice != null && selection > 1) {
                choice[0] = selection % 2;
                selection = choice[0];
            }
            if (selection == 0 && file != existing) {
                existing.delete();
            } else {
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected static PsiDirectory resolveDirectory(@NotNull PsiDirectory defaultTargetDirectory) {
        if (defaultTargetDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultTargetDirectory", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "resolveDirectory"));
        }
        Project project = defaultTargetDirectory.getProject();
        Boolean showDirsChooser = (Boolean)defaultTargetDirectory.getCopyableUserData(CopyPasteDelegator.SHOW_CHOOSER_KEY);
        if (showDirsChooser != null && showDirsChooser.booleanValue()) {
            PsiDirectoryContainer directoryContainer = PsiDirectoryFactory.getInstance(project).getDirectoryContainer(defaultTargetDirectory);
            if (directoryContainer == null) {
                return defaultTargetDirectory;
            }
            return MoveFilesOrDirectoriesUtil.resolveToDirectory(project, (PsiElement)directoryContainer);
        }
        return defaultTargetDirectory;
    }
}

