/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.ide.TitledHandler;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BasePlatformRefactoringAction;
import com.intellij.refactoring.lang.LanguageExtractInclude;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractIncludeAction
extends BasePlatformRefactoringAction {
    @Override
    public boolean isAvailableInEditorOnly() {
        return true;
    }

    @Override
    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/actions/ExtractIncludeAction", "isEnabledOnElements"));
        }
        return false;
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        return true;
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        RefactoringActionHandler handler = this.getHandler(e.getDataContext());
        if (handler instanceof TitledHandler) {
            e.getPresentation().setText(((TitledHandler)handler).getActionTitle());
        } else {
            e.getPresentation().setText("Include File...");
        }
    }

    @Override
    protected boolean isAvailableForFile(PsiFile file) {
        Language baseLanguage = file.getViewProvider().getBaseLanguage();
        return LanguageExtractInclude.INSTANCE.forLanguage(baseLanguage) != null;
    }

    @Override
    @Nullable
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/refactoring/actions/ExtractIncludeAction", "getRefactoringHandler"));
        }
        return null;
    }

    @Override
    @Nullable
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider, PsiElement element) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/refactoring/actions/ExtractIncludeAction", "getRefactoringHandler"));
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return null;
        }
        return (RefactoringActionHandler)LanguageExtractInclude.INSTANCE.forLanguage(file.getViewProvider().getBaseLanguage());
    }
}

