/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePatterns;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.tree.LanguagePerFileConfigurable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataLanguageConfigurable
extends LanguagePerFileConfigurable<Language> {
    public TemplateDataLanguageConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/templateLanguages/TemplateDataLanguageConfigurable", "<init>"));
        }
        super(project, Language.class, TemplateDataLanguageMappings.getInstance(project), LangBundle.message("dialog.template.data.language.caption", ApplicationNamesInfo.getInstance().getFullProductName()), LangBundle.message("template.data.language.configurable.tree.table.title", new Object[0]), LangBundle.message("template.data.language.override.warning.text", new Object[0]), LangBundle.message("template.data.language.override.warning.title", new Object[0]));
    }

    @Override
    protected boolean handleDefaultValue(VirtualFile file, ColoredTableCellRenderer renderer) {
        Language language = TemplateDataLanguagePatterns.getInstance().getTemplateDataLanguageByFileName(file);
        if (language != null) {
            renderer.append(this.visualize(language), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            return true;
        }
        return false;
    }

    @Nls
    public String getDisplayName() {
        return LangBundle.message("template.data.language.configurable", new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.template.languages";
    }

    @Override
    protected String visualize(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/templateLanguages/TemplateDataLanguageConfigurable", "visualize"));
        }
        return language.getDisplayName();
    }
}

