/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.util.CompressionUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializedStubTree {
    private final byte[] myBytes;
    private final int myLength;
    private final long myByteContentLength;
    private final int myCharContentLength;
    private Stub myStubElement;

    public SerializedStubTree(byte[] bytes, int length, @Nullable Stub stubElement, long byteContentLength, int charContentLength) {
        this.myBytes = bytes;
        this.myLength = length;
        this.myByteContentLength = byteContentLength;
        this.myCharContentLength = charContentLength;
        this.myStubElement = stubElement;
    }

    public SerializedStubTree(DataInput in) throws IOException {
        this.myBytes = CompressionUtil.readCompressed(in);
        this.myLength = this.myBytes.length;
        this.myByteContentLength = in.readLong();
        this.myCharContentLength = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        CompressionUtil.writeCompressed(out, this.myBytes, this.myLength);
        out.writeLong(this.myByteContentLength);
        out.writeInt(this.myCharContentLength);
    }

    @NotNull
    public Stub getStub(boolean willIndexStub) throws SerializerNotFoundException {
        Stub stubElement = this.myStubElement;
        if (stubElement != null) {
            this.myStubElement = null;
            if (willIndexStub) {
                Stub stub = stubElement;
                if (stub == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/SerializedStubTree", "getStub"));
                }
                return stub;
            }
        }
        Stub stub = SerializationManagerEx.getInstanceEx().deserialize((InputStream)new UnsyncByteArrayInputStream(this.myBytes));
        if (stub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/SerializedStubTree", "getStub"));
        }
        return stub;
    }

    public boolean contentLengthMatches(long byteContentLength, int charContentLength) {
        if (this.myCharContentLength >= 0 && charContentLength >= 0) {
            return this.myCharContentLength == charContentLength;
        }
        return this.myByteContentLength == byteContentLength;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof SerializedStubTree)) {
            return false;
        }
        SerializedStubTree thatTree = (SerializedStubTree)that;
        int length = this.myLength;
        if (length != thatTree.myLength) {
            return false;
        }
        byte[] thisBytes = this.myBytes;
        byte[] thatBytes = thatTree.myBytes;
        for (int i = 0; i < length; ++i) {
            if (thisBytes[i] == thatBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.myBytes == null) {
            return 0;
        }
        int result = 1;
        for (int i = 0; i < this.myLength; ++i) {
            result = 31 * result + this.myBytes[i];
        }
        return result;
    }
}

