/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.TagNameVariantCollector;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlTagNameProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DefaultXmlTagNameProvider
implements XmlTagNameProvider {
    @Override
    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag tag, String prefix) {
        ArrayList<String> namespaces;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/impl/source/xml/DefaultXmlTagNameProvider", "addTagNameVariants"));
        }
        if (prefix.isEmpty()) {
            namespaces = new ArrayList<String>(Arrays.asList(tag.knownNamespaces()));
            namespaces.add("");
        } else {
            namespaces = new ArrayList<String>(Collections.singletonList(tag.getNamespace()));
        }
        XmlExtension xmlExtension = XmlExtension.getExtension(tag.getContainingFile());
        ArrayList<String> nsInfo = new ArrayList<String>();
        List<XmlElementDescriptor> variants = TagNameVariantCollector.getTagDescriptors(tag, namespaces, nsInfo);
        for (int i = 0; i < variants.size(); ++i) {
            String ns;
            PsiElement declaration;
            XmlElementDescriptor descriptor = variants.get(i);
            String qname = descriptor.getName((PsiElement)tag);
            if (!prefix.isEmpty() && qname.startsWith(prefix + ":")) {
                qname = qname.substring(prefix.length() + 1);
            }
            LookupElementBuilder lookupElement = (declaration = descriptor.getDeclaration()) == null ? LookupElementBuilder.create((String)qname) : LookupElementBuilder.create((Object)declaration, (String)qname);
            int separator = qname.indexOf(58);
            if (separator > 0) {
                lookupElement = lookupElement.withLookupString(qname.substring(separator + 1));
            }
            if (StringUtil.isNotEmpty((String)(ns = (String)nsInfo.get(i)))) {
                lookupElement = lookupElement.withTypeText(ns, true);
            }
            if (descriptor instanceof PsiPresentableMetaData) {
                lookupElement = lookupElement.withIcon(((PsiPresentableMetaData)descriptor).getIcon());
            }
            if (xmlExtension.useXmlTagInsertHandler()) {
                lookupElement = lookupElement.withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
            }
            elements.add(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)(separator > 0 ? 0.0 : 1.0)));
        }
    }
}

