/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.util.containers.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassMapCachingNulls<T> {
    private final Map<Class, T[]> myBackingMap;
    private final T[] myEmptyArray;
    private final Map<Class, T[]> myMap;

    public ClassMapCachingNulls(@NotNull Map<Class, T[]> backingMap, T[] emptyArray) {
        if (backingMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backingMap", "com/intellij/psi/impl/source/tree/injected/ClassMapCachingNulls", "<init>"));
        }
        this.myMap = new ConcurrentHashMap();
        this.myBackingMap = backingMap;
        this.myEmptyArray = emptyArray;
    }

    @Nullable
    public T[] get(Class aClass) {
        T[] value = this.myMap.get(aClass);
        if (value != null) {
            if (value == this.myEmptyArray) {
                return null;
            }
            assert (value.length != 0);
            return value;
        }
        List<T> result = this.getFromBackingMap(aClass);
        return this.cache(aClass, result);
    }

    private T[] cache(Class aClass, List<T> result) {
        T[] value;
        if (result == null) {
            this.myMap.put(aClass, this.myEmptyArray);
            value = null;
        } else {
            assert (!result.isEmpty());
            value = result.toArray(this.myEmptyArray);
            this.myMap.put(aClass, value);
        }
        return value;
    }

    private List<T> getFromBackingMap(Class aClass) {
        T[] value = this.myBackingMap.get(aClass);
        List<T> result = null;
        if (value != null) {
            assert (value.length != 0);
            result = new ArrayList<T>(Arrays.asList(value));
        }
        for (Class<?> aClass1 : aClass.getInterfaces()) {
            result = this.addFromUpper(result, aClass1);
        }
        Class superclass = aClass.getSuperclass();
        if (superclass != null) {
            result = this.addFromUpper(result, superclass);
        }
        return result;
    }

    private List<T> addFromUpper(List<T> value, Class superclass) {
        T[] fromUpper = this.get(superclass);
        if (fromUpper != null) {
            assert (fromUpper.length != 0);
            if (value == null) {
                value = new ArrayList<T>(fromUpper.length);
            }
            for (T t : fromUpper) {
                if (value.contains(t)) continue;
                value.add(t);
            }
            assert (!value.isEmpty());
        }
        return value;
    }

    public Map<Class, T[]> getBackingMap() {
        return this.myBackingMap;
    }

    public void clearCache() {
        this.myMap.clear();
    }
}

