/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class LeafPsiElement
extends LeafElement
implements PsiElement,
NavigationItem {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.LeafPsiElement");

    public LeafPsiElement(@NotNull IElementType type, CharSequence text) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/LeafPsiElement", "<init>"));
        }
        super(type, text);
    }

    @Deprecated
    public LeafPsiElement(@NotNull IElementType type, CharSequence buffer, int startOffset, int endOffset, CharTable table) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/LeafPsiElement", "<init>"));
        }
        super(type, table.intern(buffer, startOffset, endOffset));
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafPsiElement", "getChildren"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiElement getFirstChild() {
        return null;
    }

    public PsiElement getLastChild() {
        return null;
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/LeafPsiElement", "acceptChildren"));
        }
    }

    public PsiElement getParent() {
        return SharedImplUtil.getParent(this);
    }

    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling(this);
    }

    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling(this);
    }

    public PsiFile getContainingFile() {
        PsiFile file = SharedImplUtil.getContainingFile(this);
        if (file == null || !file.isValid()) {
            this.invalid();
        }
        return file;
    }

    private void invalid() {
        ProgressIndicatorProvider.checkCanceled();
        StringBuilder builder = new StringBuilder();
        for (TreeElement element = this; element != null; element = element.getTreeParent()) {
            if (element != this) {
                builder.append(" / ");
            }
            builder.append(element.getClass().getName()).append(':').append(element.getElementType());
        }
        throw new PsiInvalidElementAccessException((PsiElement)this, builder.toString());
    }

    public PsiElement findElementAt(int offset) {
        return this;
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(this, offset);
    }

    public PsiElement copy() {
        ASTNode elementCopy = this.copyElement();
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public boolean isValid() {
        return SharedImplUtil.isValid(this);
    }

    public boolean isWritable() {
        return SharedImplUtil.isWritable(this);
    }

    public PsiReference getReference() {
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafPsiElement", "getReferences"));
        }
        return psiReferenceArray;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/LeafPsiElement", "add"));
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/LeafPsiElement", "addBefore"));
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/LeafPsiElement", "addAfter"));
        }
        throw new IncorrectOperationException();
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/LeafPsiElement", "checkAdd"));
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/source/tree/LeafPsiElement", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "com/intellij/psi/impl/source/tree/LeafPsiElement", "addRangeBefore"));
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void delete() throws IncorrectOperationException {
        LOG.assertTrue(this.getTreeParent() != null);
        CheckUtil.checkWritable(this);
        this.getTreeParent().deleteChildInternal(this);
        this.invalidate();
    }

    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/tree/LeafPsiElement", "replace"));
        }
        return SharedImplUtil.doReplace(this, this, newElement);
    }

    @Override
    public String toString() {
        return "PsiElement(" + this.getElementType().toString() + ")";
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/LeafPsiElement", "accept"));
        }
        visitor.visitElement((PsiElement)this);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/tree/LeafPsiElement", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/tree/LeafPsiElement", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/tree/LeafPsiElement", "processDeclarations"));
        }
        return true;
    }

    public PsiElement getContext() {
        return this.getParent();
    }

    public PsiElement getNavigationElement() {
        return this;
    }

    public PsiElement getOriginalElement() {
        return this;
    }

    public boolean isPhysical() {
        PsiFile file = this.getContainingFile();
        return file != null && file.isPhysical();
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafPsiElement", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafPsiElement", "getUseScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            this.invalid();
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafPsiElement", "getProject"));
        }
        return project;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getElementType().getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafPsiElement", "getLanguage"));
        }
        return language;
    }

    public ASTNode getNode() {
        return this;
    }

    @Override
    public PsiElement getPsi() {
        return this;
    }

    public ItemPresentation getPresentation() {
        return null;
    }

    public String getName() {
        return null;
    }

    public void navigate(boolean requestFocus) {
        Navigatable descriptor = PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this);
        if (descriptor != null) {
            descriptor.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate((PsiElement)this);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }
}

