/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleProviderBinding<Provider>
implements ProviderBinding<Provider> {
    private final List<ProviderBinding.ProviderInfo<Provider, ElementPattern>> myProviderPairs = new SmartList();

    public void registerProvider(Provider provider, ElementPattern pattern, double priority) {
        this.myProviderPairs.add(new ProviderBinding.ProviderInfo<Provider, ElementPattern>(provider, pattern, priority));
    }

    @Override
    public void addAcceptableReferenceProviders(@NotNull PsiElement position, @NotNull List<ProviderBinding.ProviderInfo<Provider, ProcessingContext>> list, @NotNull PsiReferenceService.Hints hints) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/resolve/reference/SimpleProviderBinding", "addAcceptableReferenceProviders"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/psi/impl/source/resolve/reference/SimpleProviderBinding", "addAcceptableReferenceProviders"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/psi/impl/source/resolve/reference/SimpleProviderBinding", "addAcceptableReferenceProviders"));
        }
        for (ProviderBinding.ProviderInfo<Provider, ElementPattern> trinity : this.myProviderPairs) {
            if (hints != PsiReferenceService.Hints.NO_HINTS && !((PsiReferenceProvider)trinity.provider).acceptsHints(position, hints)) continue;
            ProcessingContext context = new ProcessingContext();
            if (hints != PsiReferenceService.Hints.NO_HINTS) {
                context.put(PsiReferenceService.HINTS, (Object)hints);
            }
            boolean suitable = false;
            try {
                suitable = ((ElementPattern)trinity.processingContext).accepts((Object)position, context);
            }
            catch (IndexNotReadyException ignored) {
                // empty catch block
            }
            if (!suitable) continue;
            list.add(new ProviderBinding.ProviderInfo(trinity.provider, context, trinity.priority));
        }
    }

    @Override
    public void unregisterProvider(@NotNull Provider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/resolve/reference/SimpleProviderBinding", "unregisterProvider"));
        }
        for (ProviderBinding.ProviderInfo<Provider, ElementPattern> trinity : new ArrayList<ProviderBinding.ProviderInfo<Provider, ElementPattern>>(this.myProviderPairs)) {
            if (!trinity.provider.equals(provider)) continue;
            this.myProviderPairs.remove(trinity);
        }
    }
}

