/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NamedObjectProviderBinding<Provider>
implements ProviderBinding<Provider> {
    private final Map<String, List<ProviderBinding.ProviderInfo<Provider, ElementPattern>>> myNamesToProvidersMap = new THashMap(5);
    private final Map<String, List<ProviderBinding.ProviderInfo<Provider, ElementPattern>>> myNamesToProvidersMapInsensitive = new THashMap(5);

    public void registerProvider(@NonNls @NotNull String[] names, @NotNull ElementPattern filter, boolean caseSensitive, @NotNull Provider provider, double priority) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "registerProvider"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "registerProvider"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "registerProvider"));
        }
        Map<String, List<ProviderBinding.ProviderInfo<Provider, ElementPattern>>> map = caseSensitive ? this.myNamesToProvidersMap : this.myNamesToProvidersMapInsensitive;
        for (String attributeName : names) {
            String key = caseSensitive ? attributeName : attributeName.toLowerCase();
            SmartList psiReferenceProviders = map.get(key);
            if (psiReferenceProviders == null) {
                psiReferenceProviders = new SmartList();
                map.put(key, (List<ProviderBinding.ProviderInfo<Provider, ElementPattern>>)psiReferenceProviders);
            }
            psiReferenceProviders.add(new ProviderBinding.ProviderInfo<Provider, ElementPattern>(provider, filter, priority));
        }
    }

    @Override
    public void addAcceptableReferenceProviders(@NotNull PsiElement position, @NotNull List<ProviderBinding.ProviderInfo<Provider, ProcessingContext>> list, @NotNull PsiReferenceService.Hints hints) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "addAcceptableReferenceProviders"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "addAcceptableReferenceProviders"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "addAcceptableReferenceProviders"));
        }
        String name = this.getName(position);
        if (name != null) {
            this.addMatchingProviders(position, this.myNamesToProvidersMap.get(name), list, hints);
            this.addMatchingProviders(position, this.myNamesToProvidersMapInsensitive.get(name.toLowerCase()), list, hints);
        }
    }

    @Override
    public void unregisterProvider(@NotNull Provider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "unregisterProvider"));
        }
        for (List<ProviderBinding.ProviderInfo<Provider, ElementPattern>> list : this.myNamesToProvidersMap.values()) {
            for (ProviderBinding.ProviderInfo<Provider, ElementPattern> trinity : new ArrayList<ProviderBinding.ProviderInfo<Provider, ElementPattern>>(list)) {
                if (!trinity.provider.equals(provider)) continue;
                list.remove(trinity);
            }
        }
        for (List<ProviderBinding.ProviderInfo<Provider, ElementPattern>> list : this.myNamesToProvidersMapInsensitive.values()) {
            for (ProviderBinding.ProviderInfo<Provider, ElementPattern> trinity : new ArrayList<ProviderBinding.ProviderInfo<Provider, ElementPattern>>(list)) {
                if (!trinity.provider.equals(provider)) continue;
                list.remove(trinity);
            }
        }
    }

    @Nullable
    protected abstract String getName(PsiElement var1);

    private void addMatchingProviders(PsiElement position, @Nullable List<ProviderBinding.ProviderInfo<Provider, ElementPattern>> providerList, @NotNull List<ProviderBinding.ProviderInfo<Provider, ProcessingContext>> ret, PsiReferenceService.Hints hints) {
        if (ret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ret", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "addMatchingProviders"));
        }
        if (providerList == null) {
            return;
        }
        for (ProviderBinding.ProviderInfo<Provider, ElementPattern> trinity : providerList) {
            if (hints != PsiReferenceService.Hints.NO_HINTS && !((PsiReferenceProvider)trinity.provider).acceptsHints(position, hints)) continue;
            ProcessingContext context = new ProcessingContext();
            if (hints != PsiReferenceService.Hints.NO_HINTS) {
                context.put(PsiReferenceService.HINTS, (Object)hints);
            }
            boolean suitable = false;
            try {
                suitable = ((ElementPattern)trinity.processingContext).accepts((Object)position, context);
            }
            catch (IndexNotReadyException ignored) {
                // empty catch block
            }
            if (!suitable) continue;
            ret.add(new ProviderBinding.ProviderInfo(trinity.provider, context, trinity.priority));
        }
    }
}

