/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html.dtd;

import com.intellij.html.RelaxedHtmlNSDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.SimpleFieldCache;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlNSTypeDescriptorProvider;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlNSDescriptorImpl
implements XmlNSDescriptor,
DumbAware,
XmlNSTypeDescriptorProvider {
    private final XmlNSDescriptor myDelegate;
    private final boolean myRelaxed;
    private final boolean myCaseSensitive;
    private static final SimpleFieldCache<Map<String, XmlElementDescriptor>, HtmlNSDescriptorImpl> myCachedDeclsCache = new SimpleFieldCache<Map<String, XmlElementDescriptor>, HtmlNSDescriptorImpl>(){

        protected Map<String, XmlElementDescriptor> compute(HtmlNSDescriptorImpl htmlNSDescriptor) {
            return htmlNSDescriptor.doBuildCachedMap();
        }

        protected Map<String, XmlElementDescriptor> getValue(HtmlNSDescriptorImpl htmlNSDescriptor) {
            return htmlNSDescriptor.myCachedDecls;
        }

        protected void putValue(Map<String, XmlElementDescriptor> map, HtmlNSDescriptorImpl htmlNSDescriptor) {
            htmlNSDescriptor.myCachedDecls = map;
        }
    };
    private volatile Map<String, XmlElementDescriptor> myCachedDecls;

    public HtmlNSDescriptorImpl(XmlNSDescriptor _delegate) {
        this(_delegate, _delegate instanceof RelaxedHtmlNSDescriptor, false);
    }

    public HtmlNSDescriptorImpl(XmlNSDescriptor _delegate, boolean relaxed, boolean caseSensitive) {
        this.myDelegate = _delegate;
        this.myRelaxed = relaxed;
        this.myCaseSensitive = caseSensitive;
    }

    private Map<String, XmlElementDescriptor> buildDeclarationMap() {
        return (Map)myCachedDeclsCache.get((Object)this);
    }

    private HashMap<String, XmlElementDescriptor> doBuildCachedMap() {
        XmlElementDescriptor[] elements;
        HashMap<String, XmlElementDescriptor> decls = new HashMap<String, XmlElementDescriptor>();
        for (XmlElementDescriptor element : elements = this.myDelegate == null ? XmlElementDescriptor.EMPTY_ARRAY : this.myDelegate.getRootElementsDescriptors(null)) {
            decls.put(element.getName(), new HtmlElementDescriptorImpl(element, this.myRelaxed, this.myCaseSensitive));
        }
        return decls;
    }

    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        XmlElementDescriptor xmlElementDescriptor;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/impl/source/html/dtd/HtmlNSDescriptorImpl", "getElementDescriptor"));
        }
        String name = tag.getLocalName();
        if (!this.myCaseSensitive) {
            name = name.toLowerCase();
        }
        if ((xmlElementDescriptor = this.buildDeclarationMap().get(name)) == null && this.myRelaxed) {
            xmlElementDescriptor = this.myDelegate.getElementDescriptor(tag);
        }
        return xmlElementDescriptor;
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument document) {
        XmlElementDescriptor[] xmlElementDescriptorArray = this.myDelegate == null ? XmlElementDescriptor.EMPTY_ARRAY : this.myDelegate.getRootElementsDescriptors(document);
        if (xmlElementDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/html/dtd/HtmlNSDescriptorImpl", "getRootElementsDescriptors"));
        }
        return xmlElementDescriptorArray;
    }

    @Nullable
    public XmlFile getDescriptorFile() {
        return this.myDelegate == null ? null : this.myDelegate.getDescriptorFile();
    }

    public boolean isHierarhyEnabled() {
        return false;
    }

    public PsiElement getDeclaration() {
        return this.myDelegate == null ? null : this.myDelegate.getDeclaration();
    }

    public String getName(PsiElement context) {
        return this.myDelegate == null ? "" : this.myDelegate.getName(context);
    }

    public String getName() {
        return this.myDelegate == null ? "" : this.myDelegate.getName();
    }

    public void init(PsiElement element) {
        this.myDelegate.init(element);
    }

    public Object[] getDependences() {
        return this.myDelegate == null ? null : this.myDelegate.getDependences();
    }

    @Override
    public TypeDescriptor getTypeDescriptor(String name, XmlTag context) {
        return this.myDelegate instanceof XmlNSTypeDescriptorProvider ? ((XmlNSTypeDescriptorProvider)this.myDelegate).getTypeDescriptor(name, context) : null;
    }

    @Override
    public TypeDescriptor getTypeDescriptor(XmlTag descriptorTag) {
        return this.myDelegate instanceof XmlNSTypeDescriptorProvider ? ((XmlNSTypeDescriptorProvider)this.myDelegate).getTypeDescriptor(descriptorTag) : null;
    }
}

