/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.psi.impl.source.codeStyle.LegacyCodeStyleSchemesSettings;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CodeStyleSchemeSettings", storages={@Storage(file="$APP_CONFIG$/code.style.schemes.xml")})
public class PersistableCodeStyleSchemes
extends CodeStyleSchemesImpl
implements PersistentStateComponent<Element>,
NamedComponent {
    @NonNls
    static final String CODE_STYLE_SCHEMES_FILE = "code.style.schemes.xml";
    private boolean isLoaded;

    public PersistableCodeStyleSchemes(SchemesManagerFactory schemesManagerFactory) {
        super(schemesManagerFactory);
    }

    @Nullable
    public Element getState() {
        return XmlSerializer.serialize((Object)((Object)this), (SerializationFilter)new SerializationFilter(){

            public boolean accepts(Accessor accessor, Object bean) {
                return accessor.getValueClass().equals(String.class);
            }
        });
    }

    public void loadState(Element state2) {
        this.init();
        XmlSerializer.deserializeInto((Object)((Object)this), (Element)state2);
        this.isLoaded = true;
        this.updateCurrentScheme();
    }

    @NotNull
    public String getComponentName() {
        if ("CodeStyleSchemeSettings" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/PersistableCodeStyleSchemes", "getComponentName"));
        }
        return "CodeStyleSchemeSettings";
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void loadSettings() {
        this.init();
        LegacyCodeStyleSchemesSettings legacySettings = (LegacyCodeStyleSchemesSettings)ServiceManager.getService(LegacyCodeStyleSchemesSettings.class);
        if (legacySettings != null) {
            this.CURRENT_SCHEME_NAME = legacySettings.CURRENT_SCHEME_NAME;
        }
        this.isLoaded = true;
        this.updateCurrentScheme();
    }

    private void updateCurrentScheme() {
        CodeStyleScheme current = this.findSchemeByName(this.CURRENT_SCHEME_NAME);
        if (current == null) {
            current = this.getDefaultScheme();
        }
        this.setCurrentScheme(current);
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{new File(PathManager.getConfigPath() + File.separator + "codestyles"), new File(PathManager.getOptionsPath() + File.separator + CODE_STYLE_SCHEMES_FILE)};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/PersistableCodeStyleSchemes", "getExportFiles"));
        }
        return fileArray;
    }
}

