/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import java.io.IOException;
import java.util.List;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CodeStyleSchemesImpl
extends CodeStyleSchemes
implements ExportableComponent {
    @NonNls
    public static final String DEFAULT_SCHEME_NAME = "Default";
    public String CURRENT_SCHEME_NAME = "Default";
    private boolean myIsInitialized = false;
    @NonNls
    static final String CODE_STYLES_DIRECTORY = "codestyles";
    private final SchemesManager<CodeStyleScheme, CodeStyleSchemeImpl> mySchemesManager;
    @NonNls
    private static final String FILE_SPEC = "$ROOT_CONFIG$/codestyles";

    public CodeStyleSchemesImpl(SchemesManagerFactory schemesManagerFactory) {
        BaseSchemeProcessor<CodeStyleSchemeImpl> processor = new BaseSchemeProcessor<CodeStyleSchemeImpl>(){

            public CodeStyleSchemeImpl readScheme(@NotNull Document schemeContent) throws IOException, JDOMException, InvalidDataException {
                if (schemeContent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeContent", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "readScheme"));
                }
                return CodeStyleSchemeImpl.readScheme(schemeContent);
            }

            public Parent writeScheme(@NotNull CodeStyleSchemeImpl scheme) throws WriteExternalException {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "writeScheme"));
                }
                return scheme.saveToDocument();
            }

            public boolean shouldBeSaved(@NotNull CodeStyleSchemeImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "shouldBeSaved"));
                }
                return !scheme.isDefault();
            }

            public void initScheme(@NotNull CodeStyleSchemeImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "initScheme"));
                }
                scheme.init(CodeStyleSchemesImpl.this);
            }
        };
        this.mySchemesManager = schemesManagerFactory.createSchemesManager(FILE_SPEC, (SchemeProcessor)processor, RoamingType.PER_USER);
        this.init();
        this.addScheme(new CodeStyleSchemeImpl(DEFAULT_SCHEME_NAME, true, null));
        this.setCurrentScheme(this.getDefaultScheme());
    }

    public CodeStyleScheme[] getSchemes() {
        List schemes = this.mySchemesManager.getAllSchemes();
        return schemes.toArray(new CodeStyleScheme[schemes.size()]);
    }

    public CodeStyleScheme getCurrentScheme() {
        return (CodeStyleScheme)this.mySchemesManager.getCurrentScheme();
    }

    public void setCurrentScheme(CodeStyleScheme scheme) {
        String schemeName = scheme == null ? null : scheme.getName();
        this.mySchemesManager.setCurrentSchemeName(schemeName);
        this.CURRENT_SCHEME_NAME = schemeName;
    }

    public CodeStyleScheme createNewScheme(String preferredName, CodeStyleScheme parentScheme) {
        String name;
        if (preferredName == null) {
            if (parentScheme == null) {
                throw new IllegalArgumentException("parentScheme must not be null");
            }
            name = null;
            int i = 1;
            while (name == null) {
                String currName = parentScheme.getName() + " (" + i + ")";
                if (this.findSchemeByName(currName) == null) {
                    name = currName;
                }
                ++i;
            }
        } else {
            name = null;
            int i = 0;
            while (name == null) {
                String currName;
                String string = currName = i == 0 ? preferredName : preferredName + " (" + i + ")";
                if (this.findSchemeByName(currName) == null) {
                    name = currName;
                }
                ++i;
            }
        }
        return new CodeStyleSchemeImpl(name, false, parentScheme);
    }

    public void deleteScheme(CodeStyleScheme scheme) {
        if (scheme.isDefault()) {
            throw new IllegalArgumentException("Unable to delete default scheme!");
        }
        CodeStyleSchemeImpl currScheme = (CodeStyleSchemeImpl)this.getCurrentScheme();
        if (currScheme == scheme) {
            CodeStyleScheme newCurrentScheme = this.getDefaultScheme();
            if (newCurrentScheme == null) {
                throw new IllegalStateException("Unable to load default scheme!");
            }
            this.setCurrentScheme(newCurrentScheme);
        }
        this.mySchemesManager.removeScheme((Scheme)scheme);
    }

    public CodeStyleScheme getDefaultScheme() {
        return this.findSchemeByName(DEFAULT_SCHEME_NAME);
    }

    public CodeStyleScheme findSchemeByName(String name) {
        return (CodeStyleScheme)this.mySchemesManager.findSchemeByName(name);
    }

    public void addScheme(CodeStyleScheme scheme) {
        this.mySchemesManager.addNewScheme((Scheme)scheme, true);
    }

    protected void init() {
        if (this.myIsInitialized) {
            return;
        }
        this.myIsInitialized = true;
        this.mySchemesManager.loadSchemes();
    }

    @NotNull
    public String getPresentableName() {
        String string = PsiBundle.message((String)"codestyle.export.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "getPresentableName"));
        }
        return string;
    }

    public SchemesManager<CodeStyleScheme, CodeStyleSchemeImpl> getSchemesManager() {
        return this.mySchemesManager;
    }
}

