/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.DefaultInjectedLanguageBlockBuilder;
import com.intellij.psi.formatter.common.SettingsAwareBlock;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlock
implements ASTBlock {
    public static final List<Block> EMPTY = Collections.emptyList();
    @NotNull
    protected final ASTNode myNode;
    @Nullable
    protected final Wrap myWrap;
    @Nullable
    protected final Alignment myAlignment;
    private List<Block> mySubBlocks;
    private Boolean myIncomplete;

    protected AbstractBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/formatter/common/AbstractBlock", "<init>"));
        }
        this.myNode = node;
        this.myWrap = wrap;
        this.myAlignment = alignment;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/common/AbstractBlock", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            List<Block> list = this.buildChildren();
            if (list.isEmpty()) {
                list = this.buildInjectedBlocks();
            }
            this.mySubBlocks = !list.isEmpty() ? list : EMPTY;
        }
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/common/AbstractBlock", "getSubBlocks"));
        }
        return list;
    }

    @NotNull
    private List<Block> buildInjectedBlocks() {
        if (!(this instanceof SettingsAwareBlock)) {
            List<Block> list = EMPTY;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/common/AbstractBlock", "buildInjectedBlocks"));
            }
            return list;
        }
        PsiElement psi = this.myNode.getPsi();
        if (psi == null) {
            List<Block> list = EMPTY;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/common/AbstractBlock", "buildInjectedBlocks"));
            }
            return list;
        }
        PsiFile file = psi.getContainingFile();
        if (file == null) {
            List<Block> list = EMPTY;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/common/AbstractBlock", "buildInjectedBlocks"));
            }
            return list;
        }
        if (InjectedLanguageUtil.getCachedInjectedDocuments(file).isEmpty()) {
            List<Block> list = EMPTY;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/common/AbstractBlock", "buildInjectedBlocks"));
            }
            return list;
        }
        TextRange blockRange = this.myNode.getTextRange();
        ConcurrentList<DocumentWindow> documentWindows = InjectedLanguageUtil.getCachedInjectedDocuments(file);
        for (DocumentWindow documentWindow : documentWindows) {
            PsiFile injected;
            int endOffset;
            int startOffset = documentWindow.injectedToHost(0);
            if (!blockRange.containsRange(startOffset, endOffset = startOffset + documentWindow.getTextLength()) || (injected = PsiDocumentManager.getInstance((Project)psi.getProject()).getCachedPsiFile((Document)documentWindow)) == null) continue;
            ArrayList result = ContainerUtilRt.newArrayList();
            DefaultInjectedLanguageBlockBuilder builder = new DefaultInjectedLanguageBlockBuilder(((SettingsAwareBlock)((Object)this)).getSettings());
            builder.addInjectedBlocks(result, this.myNode, this.getWrap(), this.getAlignment(), this.getIndent());
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/common/AbstractBlock", "buildInjectedBlocks"));
            }
            return arrayList;
        }
        List<Block> list = EMPTY;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/common/AbstractBlock", "buildInjectedBlocks"));
        }
        return list;
    }

    protected abstract List<Block> buildChildren();

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    public Indent getIndent() {
        return null;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this.myNode;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/common/AbstractBlock", "getNode"));
        }
        return aSTNode;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = new ChildAttributes(this.getChildIndent(), this.getFirstChildAlignment());
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/common/AbstractBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    @Nullable
    private Alignment getFirstChildAlignment() {
        List<Block> subBlocks = this.getSubBlocks();
        for (Block subBlock : subBlocks) {
            Alignment alignment = subBlock.getAlignment();
            if (alignment == null) continue;
            return alignment;
        }
        return null;
    }

    @Nullable
    protected Indent getChildIndent() {
        return null;
    }

    public boolean isIncomplete() {
        if (this.myIncomplete == null) {
            this.myIncomplete = FormatterUtil.isIncomplete(this.getNode());
        }
        return this.myIncomplete;
    }

    public String toString() {
        return this.myNode.getText() + " " + this.getTextRange();
    }
}

