/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.filter;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.filter.InspectionsFilter;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;

public class InspectionFilterAction
extends DefaultActionGroup
implements Toggleable,
DumbAware {
    private final SeverityRegistrar mySeverityRegistrar;
    private final InspectionsFilter myInspectionsFilter;

    public InspectionFilterAction(InspectionProfileImpl profile, InspectionsFilter inspectionsFilter, Project project) {
        super("Filter Inspections", true);
        this.myInspectionsFilter = inspectionsFilter;
        this.mySeverityRegistrar = ((SeverityProvider)profile.getProfileManager()).getOwnSeverityRegistrar();
        this.getTemplatePresentation().setIcon(AllIcons.General.Filter);
        this.tune(profile, project);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().putClientProperty("selected", (Object)(!this.myInspectionsFilter.isEmptyFilter() ? 1 : 0));
    }

    private void tune(InspectionProfileImpl profile, Project project) {
        this.addAction((AnAction)new ResetFilterAction());
        this.addSeparator();
        this.addAction((AnAction)new ShowEnabledOrDisabledInspectionsAction(true));
        this.addAction((AnAction)new ShowEnabledOrDisabledInspectionsAction(false));
        this.addSeparator();
        SortedSet<HighlightSeverity> severities = LevelChooserAction.getSeverities(this.mySeverityRegistrar);
        for (HighlightSeverity severity : severities) {
            this.add((AnAction)new ShowWithSpecifiedSeverityInspectionsAction(severity));
        }
        this.addSeparator();
        HashSet languageIds = new HashSet();
        for (ScopeToolState state2 : profile.getDefaultStates(project)) {
            String languageId = state2.getTool().getLanguage();
            languageIds.add(languageId);
        }
        ArrayList<Language> languages = new ArrayList<Language>();
        for (String id : languageIds) {
            Language language;
            if (id == null || (language = Language.findLanguageByID((String)id)) == null) continue;
            languages.add(language);
        }
        if (!languages.isEmpty()) {
            Collections.sort(languages, new Comparator<Language>(){

                @Override
                public int compare(Language l1, Language l2) {
                    return l1.getDisplayName().compareTo(l2.getDisplayName());
                }
            });
            for (Language language : languages) {
                this.add((AnAction)new LanguageFilterAction(language));
            }
            this.addSeparator();
        }
        this.add((AnAction)new ShowAvailableOnlyOnAnalyzeInspectionsAction());
        this.add((AnAction)new ShowOnlyCleanupInspectionsAction());
    }

    private class LanguageFilterAction
    extends CheckboxAction
    implements DumbAware {
        private final String myLanguageId;

        public LanguageFilterAction(Language language) {
            super(language.getDisplayName());
            this.myLanguageId = language.getID();
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.containsLanguageId(this.myLanguageId);
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            if (state2) {
                InspectionFilterAction.this.myInspectionsFilter.addLanguageId(this.myLanguageId);
            } else {
                InspectionFilterAction.this.myInspectionsFilter.removeLanguageId(this.myLanguageId);
            }
        }
    }

    private class ShowEnabledOrDisabledInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        private final Boolean myShowEnabledActions;

        public ShowEnabledOrDisabledInspectionsAction(boolean showEnabledActions) {
            super("Show Only " + (showEnabledActions ? "Enabled" : "Disabled"));
            this.myShowEnabledActions = showEnabledActions;
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.getSuitableInspectionsStates() == this.myShowEnabledActions;
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            boolean previousState = this.isSelected(e);
            InspectionFilterAction.this.myInspectionsFilter.setSuitableInspectionsStates(previousState ? null : this.myShowEnabledActions);
        }
    }

    private class ShowWithSpecifiedSeverityInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        private final HighlightSeverity mySeverity;

        private ShowWithSpecifiedSeverityInspectionsAction(HighlightSeverity severity) {
            super(SingleInspectionProfilePanel.renderSeverity(severity), null, HighlightDisplayLevel.find((HighlightSeverity)severity).getIcon());
            this.mySeverity = severity;
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.containsSeverity(this.mySeverity);
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            if (state2) {
                InspectionFilterAction.this.myInspectionsFilter.addSeverity(this.mySeverity);
            } else {
                InspectionFilterAction.this.myInspectionsFilter.removeSeverity(this.mySeverity);
            }
        }
    }

    private class ShowAvailableOnlyOnAnalyzeInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        public ShowAvailableOnlyOnAnalyzeInspectionsAction() {
            super("Show Only \"Available only for Analyze | Inspect Code\"");
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.isAvailableOnlyForAnalyze();
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            InspectionFilterAction.this.myInspectionsFilter.setAvailableOnlyForAnalyze(state2);
        }
    }

    private class ShowOnlyCleanupInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        public ShowOnlyCleanupInspectionsAction() {
            super("Show Only Cleanup Inspections");
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.isShowOnlyCleanupInspections();
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            InspectionFilterAction.this.myInspectionsFilter.setShowOnlyCleanupInspections(state2);
        }
    }

    private class ResetFilterAction
    extends DumbAwareAction {
        public ResetFilterAction() {
            super("Reset Filter");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/filter/InspectionFilterAction$ResetFilterAction", "actionPerformed"));
            }
            InspectionFilterAction.this.myInspectionsFilter.reset();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/filter/InspectionFilterAction$ResetFilterAction", "update"));
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(!InspectionFilterAction.this.myInspectionsFilter.isEmptyFilter());
        }
    }
}

